/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.util.Iterator;
import java.util.Properties;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.EmptyNodeSet;
import org.exist.dom.persistent.NodeHandle;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.storage.Indexable;
import org.exist.storage.ValueIndexFactory;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SingleItemIterator;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AtomicValue
implements Item,
Sequence,
Indexable {
    public static final AtomicValue EMPTY_VALUE = new EmptyValue();

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public abstract String getStringValue() throws XPathException;

    @Override
    public Sequence tail() throws XPathException {
        return Sequence.EMPTY_SEQUENCE;
    }

    @Override
    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public abstract boolean compareTo(Collator var1, Constants.Comparison var2, AtomicValue var3) throws XPathException;

    public abstract int compareTo(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue max(Collator var1, AtomicValue var2) throws XPathException;

    public abstract AtomicValue min(Collator var1, AtomicValue var2) throws XPathException;

    public boolean startsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call starts-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean endsWith(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call ends-with on value of type " + Type.getTypeName(this.getType()));
    }

    public boolean contains(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot call contains on value of type " + Type.getTypeName(this.getType()));
    }

    @Override
    public int getItemCount() {
        return 1;
    }

    @Override
    public int getCardinality() {
        return 2;
    }

    @Override
    public void removeDuplicates() {
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new SingleItemIterator(this);
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return new SingleItemIterator(this);
    }

    @Override
    public int getItemType() {
        return this.getType();
    }

    @Override
    public Item itemAt(int pos) {
        return pos > 0 ? null : this;
    }

    @Override
    public Sequence toSequence() {
        return this;
    }

    @Override
    public void toSAX(DBBroker broker, ContentHandler handler, Properties properties) throws SAXException {
        try {
            String s = this.getStringValue();
            handler.characters(s.toCharArray(), 0, s.length());
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void copyTo(DBBroker broker, DocumentBuilderReceiver receiver) throws SAXException {
        try {
            String s = this.getStringValue();
            receiver.characters(s);
        }
        catch (XPathException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean hasOne() {
        return true;
    }

    @Override
    public boolean hasMany() {
        return false;
    }

    @Override
    public void add(Item item) throws XPathException {
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        return this;
    }

    @Override
    public abstract boolean effectiveBooleanValue() throws XPathException;

    @Override
    public NodeSet toNodeSet() throws XPathException {
        throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to a node set");
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + "('" + this.getStringValue() + "') to a node set");
    }

    @Override
    public DocumentSet getDocumentSet() {
        return DocumentSet.EMPTY_DOCUMENT_SET;
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return EmptyNodeSet.EMPTY_COLLECTION_ITERATOR;
    }

    public AtomicValue promote(AtomicValue otherValue) throws XPathException {
        if (this.getType() != otherValue.getType()) {
            if (Type.subTypeOf(this.getType(), 32) && (Type.subTypeOf(otherValue.getType(), 34) || Type.subTypeOf(otherValue.getType(), 33))) {
                return this.convertTo(otherValue.getType());
            }
            if (Type.subTypeOf(this.getType(), 33) && Type.subTypeOf(otherValue.getType(), 34)) {
                return this.convertTo(34);
            }
            if (Type.subTypeOf(this.getType(), 25) && Type.subTypeOf(otherValue.getType(), 22)) {
                return this.convertTo(22);
            }
        }
        return this;
    }

    public void dump(ExpressionDumper dumper) {
        try {
            dumper.display(this.getStringValue());
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException e) {
            return super.toString();
        }
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public void setIsCached(boolean cached) {
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
    }

    @Override
    public void setSelfAsContext(int contextId) throws XPathException {
    }

    @Override
    public boolean isPersistentSet() {
        return false;
    }

    @Override
    public void nodeMoved(NodeId oldNodeId, NodeHandle newNode) {
    }

    @Override
    public byte[] serializeValue(int offset) throws EXistException {
        return ValueIndexFactory.serialize(this, offset);
    }

    public int compareTo(Object other) {
        throw new IllegalArgumentException("Invalid call to compareTo by " + Type.getTypeName(this.getItemType()));
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return false;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
    }

    private static final class EmptyValue
    extends AtomicValue {
        private EmptyValue() {
        }

        @Override
        public boolean hasOne() {
            return false;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public String getStringValue() {
            return "";
        }

        @Override
        public AtomicValue convertTo(int requiredType) throws XPathException {
            switch (requiredType) {
                case 11: 
                case 20: 
                case 22: {
                    return StringValue.EMPTY_STRING;
                }
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: {
                    return new StringValue("", requiredType);
                }
                case 25: {
                    return AnyURIValue.EMPTY_URI;
                }
                case 23: {
                    return BooleanValue.FALSE;
                }
            }
            throw new XPathException("cannot convert empty value to " + requiredType);
        }

        @Override
        public boolean effectiveBooleanValue() throws XPathException {
            return false;
        }

        @Override
        public int compareTo(Collator collator, AtomicValue other) throws XPathException {
            if (other instanceof EmptyValue) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
            return false;
        }

        @Override
        public Item itemAt(int pos) {
            return null;
        }

        @Override
        public Sequence toSequence() {
            return this;
        }

        @Override
        public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        @Override
        public void add(Item item) throws XPathException {
        }

        @Override
        public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
            return this;
        }

        @Override
        public int conversionPreference(Class<?> javaClass) {
            return Integer.MAX_VALUE;
        }

        @Override
        public <T> T toJavaObject(Class<T> target) throws XPathException {
            throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
        }
    }
}

