/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.HexBinaryValueType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public abstract class BinaryValue
extends AtomicValue
implements Closeable {
    private static final Logger LOG = LogManager.getLogger(BinaryValue.class);
    protected final int READ_BUFFER_SIZE = 4096;
    private final BinaryValueManager binaryValueManager;
    private final BinaryValueType binaryValueType;

    protected BinaryValue(BinaryValueManager binaryValueManager, BinaryValueType binaryValueType) {
        this.binaryValueManager = binaryValueManager;
        this.binaryValueType = binaryValueType;
    }

    protected final BinaryValueManager getManager() {
        return this.binaryValueManager;
    }

    protected BinaryValueType getBinaryValueType() {
        return this.binaryValueType;
    }

    @Override
    public int getType() {
        return this.getBinaryValueType().getXQueryType();
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.getType() == 27 || other.getType() == 26) {
            int value = this.compareTo((BinaryValue)other);
            switch (operator) {
                case EQ: {
                    return value == 0;
                }
                case NEQ: {
                    return value != 0;
                }
                case GT: {
                    return value > 0;
                }
                case GTEQ: {
                    return value >= 0;
                }
                case LT: {
                    return value < 0;
                }
                case LTEQ: {
                    return value <= 0;
                }
            }
            throw new XPathException("Type error: cannot apply operator to numeric value");
        }
        throw new XPathException("Cannot compare value of type xs:hexBinary with " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 27 || other.getType() == 26) {
            return this.compareTo((BinaryValue)other);
        }
        throw new XPathException("Cannot compare value of type xs:hexBinary with " + Type.getTypeName(other.getType()));
    }

    private int compareTo(BinaryValue otherValue) {
        InputStream is = this.getInputStream();
        InputStream otherIs = otherValue.getInputStream();
        if (is == null && otherIs == null) {
            return 0;
        }
        if (is == null) {
            return -1;
        }
        if (otherIs == null) {
            return 1;
        }
        int read = -1;
        int otherRead = -1;
        try {
            read = is.read();
        }
        catch (IOException ioe) {
            return -1;
        }
        try {
            otherRead = otherIs.read();
        }
        catch (IOException ioe) {
            return 1;
        }
        return read - otherRead;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (target == byte[].class) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.streamBinaryTo((OutputStream)baos);
                return (T)baos.toByteArray();
            }
            catch (IOException ioe) {
                LOG.error("Unable to Stream BinaryValue to byte[]: {}", (Object)ioe.getMessage(), (Object)ioe);
            }
        }
        throw new XPathException("Cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    public <T> T toJavaObject() throws XPathException {
        return (T)this.toJavaObject(byte[].class);
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot compare values of type " + Type.getTypeName(this.getType()));
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Cannot compare values of type " + Type.getTypeName(this.getType()));
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        AtomicValue result;
        if (requiredType == this.getType() || requiredType == 11 || requiredType == 20) {
            result = this;
        } else {
            switch (requiredType) {
                case 26: {
                    result = this.convertTo(new Base64BinaryValueType());
                    break;
                }
                case 27: {
                    result = this.convertTo(new HexBinaryValueType());
                    break;
                }
                case 21: {
                    result = new UntypedAtomicValue(this.getStringValue());
                    break;
                }
                case 22: {
                    result = new StringValue(this.getStringValue());
                    break;
                }
                default: {
                    throw new XPathException("cannot convert " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(requiredType));
                }
            }
        }
        return result;
    }

    public abstract BinaryValue convertTo(BinaryValueType var1) throws XPathException;

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isArray() && javaClass.isInstance(Byte.class)) {
            return 0;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException("FORG0006: value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }

    @Override
    public String getStringValue() throws XPathException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.streamTo((OutputStream)baos);
        }
        catch (IOException ex) {
            throw new XPathException("Unable to encode string value: " + ex.getMessage(), (Throwable)ex);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException ioe) {
                LOG.error("Unable to close stream: {}", (Object)ioe.getMessage(), (Object)ioe);
            }
        }
        return new String(baos.toByteArray());
    }

    public abstract void streamBinaryTo(OutputStream var1) throws IOException;

    public void streamTo(OutputStream os) throws IOException {
        CloseShieldOutputStream safeOutputStream = new CloseShieldOutputStream(os);
        Object fos = this.getBinaryValueType().getEncoder((OutputStream)safeOutputStream);
        this.streamBinaryTo((OutputStream)fos);
        try {
            ((FilterOutputStream)fos).close();
        }
        catch (IOException ioe) {
            LOG.error("Unable to close stream: {}", (Object)ioe.getMessage(), (Object)ioe);
        }
    }

    public abstract InputStream getInputStream();

    public abstract boolean isClosed();

    public abstract void incrementSharedReferences();
}

