/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueType;

public class BinaryValueFromBinaryString
extends BinaryValue {
    private static final Logger LOG = LogManager.getLogger(BinaryValueFromBinaryString.class);
    private final String value;
    private boolean closed = false;

    public BinaryValueFromBinaryString(BinaryValueType binaryValueType, String value) throws XPathException {
        super(null, binaryValueType);
        this.value = binaryValueType.verifyAndFormatString(value);
    }

    @Override
    public BinaryValue convertTo(BinaryValueType binaryValueType) throws XPathException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FilterOutputStream fos = null;
        try {
            fos = (FilterOutputStream)binaryValueType.getEncoder((OutputStream)baos);
            this.streamBinaryTo(fos);
        }
        catch (IOException ioe) {
            throw new XPathException(ioe);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    LOG.error("Unable to close stream: {}", (Object)ioe.getMessage(), (Object)ioe);
                }
            }
            try {
                baos.close();
            }
            catch (IOException ioe) {
                LOG.error("Unable to close stream: {}", (Object)ioe.getMessage(), (Object)ioe);
            }
        }
        return new BinaryValueFromBinaryString(binaryValueType, new String(baos.toByteArray()));
    }

    @Override
    public void streamBinaryTo(OutputStream os) throws IOException {
        CloseShieldOutputStream safeOutputStream = new CloseShieldOutputStream(os);
        Object fos = this.getBinaryValueType().getDecoder((OutputStream)safeOutputStream);
        byte[] data = this.value.getBytes();
        ((FilterOutputStream)fos).write(data);
        try {
            ((FilterOutputStream)fos).close();
        }
        catch (IOException ioe) {
            LOG.error("Unable to close stream: {}", (Object)ioe.getMessage(), (Object)ioe);
        }
    }

    @Override
    public void streamTo(OutputStream os) throws IOException {
        byte[] data = this.value.getBytes();
        os.write(data);
    }

    @Override
    public InputStream getInputStream() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.streamBinaryTo((OutputStream)baos);
        }
        catch (IOException ioe) {
            LOG.error("Unable to get read only buffer: {}", (Object)ioe.getMessage(), (Object)ioe);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void incrementSharedReferences() {
        throw new UnsupportedOperationException();
    }
}

