/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.exist.util.io.ByteBufferAccessor;
import org.exist.util.io.ByteBufferInputStream;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;

public class BinaryValueFromFile
extends BinaryValue {
    private final File file;
    private final FileChannel channel;
    private final MappedByteBuffer buf;

    protected BinaryValueFromFile(BinaryValueManager manager, BinaryValueType binaryValueType, File file) throws XPathException {
        super(manager, binaryValueType);
        try {
            this.file = file;
            this.channel = new RandomAccessFile(file, "r").getChannel();
            this.buf = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        }
        catch (IOException ioe) {
            throw new XPathException(ioe);
        }
    }

    public static BinaryValueFromFile getInstance(BinaryValueManager manager, BinaryValueType binaryValueType, File file) throws XPathException {
        BinaryValueFromFile binaryFile = new BinaryValueFromFile(manager, binaryValueType, file);
        manager.registerBinaryValueInstance(binaryFile);
        return binaryFile;
    }

    @Override
    public BinaryValue convertTo(BinaryValueType binaryValueType) throws XPathException {
        BinaryValueFromFile binaryFile = new BinaryValueFromFile(this.getManager(), binaryValueType, this.file);
        this.getManager().registerBinaryValueInstance(binaryFile);
        return binaryFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamBinaryTo(OutputStream os) throws IOException {
        if (!this.channel.isOpen()) {
            throw new IOException("Underlying channel has been closed");
        }
        try {
            byte[] data = new byte[4096];
            while (this.buf.hasRemaining()) {
                int remaining = this.buf.remaining();
                if (remaining < 4096) {
                    data = new byte[remaining];
                }
                this.buf.get(data);
                os.write(data, 0, data.length);
            }
            os.flush();
        }
        finally {
            this.buf.position(0);
        }
    }

    @Override
    public boolean isClosed() {
        return !this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    @Override
    public InputStream getInputStream() {
        return new ByteBufferInputStream(new ByteBufferAccessor(){
            private ByteBuffer roBuf;

            @Override
            public ByteBuffer getBuffer() {
                if (this.roBuf == null) {
                    this.roBuf = BinaryValueFromFile.this.buf.asReadOnlyBuffer();
                }
                return this.roBuf;
            }
        });
    }

    public Object toJavaObject() throws XPathException {
        return this.file;
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
        if (contextSequence == this || contextSequence instanceof ValueSequence && ((ValueSequence)contextSequence).containsValue(this)) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        context.destroyBinaryValue(this);
    }

    @Override
    public void incrementSharedReferences() {
        throw new UnsupportedOperationException();
    }
}

