/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.exist.xquery.XPathException;

public abstract class BinaryValueType<T extends FilterOutputStream> {
    private final int xqueryType;
    private final Class<T> coder;

    public BinaryValueType(int xqueryType, Class<T> coder) {
        this.xqueryType = xqueryType;
        this.coder = coder;
    }

    public int getXQueryType() {
        return this.xqueryType;
    }

    public T getEncoder(OutputStream os) throws IOException {
        return this.instantiateCoder(os, true);
    }

    public T getDecoder(OutputStream os) throws IOException {
        return this.instantiateCoder(os, false);
    }

    private T instantiateCoder(OutputStream stream, boolean encoder) throws IOException {
        try {
            Constructor<T> c = this.coder.getConstructor(OutputStream.class, Boolean.TYPE);
            FilterOutputStream f = (FilterOutputStream)c.newInstance(stream, encoder);
            return (T)f;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException nsme) {
            throw new IOException("Unable to get binary coder '" + this.coder.getName() + "': " + nsme.getMessage(), nsme);
        }
    }

    public String verifyAndFormatString(String str) throws XPathException {
        str = str.replaceAll("\\s", "");
        this.verifyString(str);
        return this.formatString(str);
    }

    protected abstract void verifyString(String var1) throws XPathException;

    protected abstract String formatString(String var1);
}

