/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class BooleanValue
extends AtomicValue {
    public static final BooleanValue TRUE = new BooleanValue(true);
    public static final BooleanValue FALSE = new BooleanValue(false);
    private final boolean value;

    public BooleanValue(boolean bool) {
        this.value = bool;
    }

    public static final BooleanValue valueOf(boolean bool) {
        return bool ? TRUE : FALSE;
    }

    @Override
    public int getType() {
        return 23;
    }

    @Override
    public String getStringValue() throws XPathException {
        return this.value ? "true" : "false";
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 23: {
                return this;
            }
            case 30: 
            case 31: {
                return new IntegerValue(this.value ? 1L : 0L);
            }
            case 32: {
                return new DecimalValue(this.value ? 1.0 : 0.0);
            }
            case 33: {
                return new FloatValue(this.value ? 1.0f : 0.0f);
            }
            case 34: {
                return new DoubleValue(this.value ? 1.0 : 0.0);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException(ErrorCodes.XPTY0004, "cannot convert 'xs:boolean(" + this.value + ")' to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 23)) {
            boolean otherVal = ((BooleanValue)other).getValue();
            switch (operator) {
                case EQ: {
                    return this.value == otherVal;
                }
                case NEQ: {
                    return this.value != otherVal;
                }
                case LT: {
                    return !this.value && otherVal;
                }
                case LTEQ: {
                    return this.value == otherVal || !this.value && otherVal;
                }
                case GT: {
                    return this.value && !otherVal;
                }
                case GTEQ: {
                    return this.value == otherVal || this.value && !otherVal;
                }
            }
            throw new XPathException("Type error: cannot apply this operator to a boolean value");
        }
        throw new XPathException(ErrorCodes.XPTY0004, "cannot convert 'xs:boolean(" + this.value + ")' to " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        boolean otherVal = other.effectiveBooleanValue();
        if (otherVal == this.value) {
            return 0;
        }
        if (this.value) {
            return 1;
        }
        return -1;
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return this.value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 23) {
            boolean otherValue = ((BooleanValue)other).value;
            return this.value && !otherValue ? this : other;
        }
        throw new XPathException("Invalid argument to aggregate function: expected boolean, got: " + Type.getTypeName(other.getType()));
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == 23) {
            boolean otherValue = ((BooleanValue)other).value;
            return !this.value && otherValue ? this : other;
        }
        throw new XPathException("Invalid argument to aggregate function: expected boolean, got: " + Type.getTypeName(other.getType()));
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(BooleanValue.class)) {
            return 0;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 1;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        if (javaClass == String.class || javaClass == CharSequence.class) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(BooleanValue.class)) {
            return (T)this;
        }
        if (target == Boolean.class || target == Boolean.TYPE || target == Object.class) {
            return (T)Boolean.valueOf(this.value);
        }
        if (target == String.class || target == CharSequence.class) {
            StringValue v = (StringValue)this.convertTo(22);
            return (T)v.value;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    @Override
    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 23)) {
            if (this.value == ((BooleanValue)other).value) {
                return 0;
            }
            if (this.value) {
                return 1;
            }
            return -1;
        }
        return this.getType() < other.getType() ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BooleanValue) {
            return this.value == ((BooleanValue)obj).value;
        }
        return false;
    }
}

