/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.GDayValue;
import org.exist.xquery.value.GMonthDayValue;
import org.exist.xquery.value.GMonthValue;
import org.exist.xquery.value.GYearMonthValue;
import org.exist.xquery.value.GYearValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.TimeValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.YearMonthDurationValue;

public class DateTimeValue
extends AbstractDateTimeValue {
    public DateTimeValue() throws XPathException {
        super(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar()));
        this.normalize();
    }

    public DateTimeValue(XMLGregorianCalendar calendar) {
        super(DateTimeValue.fillCalendar(DateTimeValue.cloneXMLGregorianCalendar(calendar)));
        this.normalize();
    }

    public DateTimeValue(Date date) {
        super(DateTimeValue.dateToXMLGregorianCalendar(date));
        this.normalize();
    }

    public DateTimeValue(String dateTime) throws XPathException {
        super(dateTime);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.DATETIME) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:dateTime instance must have all fields set");
        }
        this.normalize();
    }

    private static XMLGregorianCalendar dateToXMLGregorianCalendar(Date date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        XMLGregorianCalendar xgc = TimeUtils.getInstance().newXMLGregorianCalendar(gc);
        xgc.normalize();
        return xgc;
    }

    private static XMLGregorianCalendar fillCalendar(XMLGregorianCalendar calendar) {
        if (calendar.getHour() == Integer.MIN_VALUE) {
            calendar.setHour(0);
        }
        if (calendar.getMinute() == Integer.MIN_VALUE) {
            calendar.setMinute(0);
        }
        if (calendar.getSecond() == Integer.MIN_VALUE) {
            calendar.setSecond(0);
        }
        if (calendar.getMillisecond() == Integer.MIN_VALUE) {
            calendar.setMillisecond(0);
        }
        return calendar;
    }

    protected void normalize() {
        if (this.calendar.getHour() == 24 && this.calendar.getMinute() == 0 && this.calendar.getSecond() == 0) {
            this.calendar.setHour(0);
            this.calendar.add(TimeUtils.ONE_DAY);
        }
    }

    @Override
    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new DateTimeValue(cal);
    }

    @Override
    protected QName getXMLSchemaType() {
        return DatatypeConstants.DATETIME;
    }

    @Override
    public int getType() {
        return 50;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 50: {
                return this;
            }
            case 51: {
                return new DateValue(this.calendar);
            }
            case 52: {
                return new TimeValue(this.calendar);
            }
            case 56: {
                return new GYearValue(this.calendar);
            }
            case 59: {
                return new GYearMonthValue(this.calendar);
            }
            case 71: {
                return new GMonthDayValue(this.calendar);
            }
            case 58: {
                return new GDayValue(this.calendar);
            }
            case 57: {
                return new GMonthValue(this.calendar);
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:dateTime to " + Type.getTypeName(requiredType));
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 50: {
                return new DayTimeDurationValue(this.getTimeInMillis() - ((DateTimeValue)other).getTimeInMillis());
            }
            case 54: {
                return ((YearMonthDurationValue)other).negate().plus(this);
            }
            case 55: {
                return ((DayTimeDurationValue)other).negate().plus(this);
            }
        }
        throw new XPathException("Operand to minus should be of type xs:dateTime, xdt:dayTimeDuration or xdt:yearMonthDuration; got: " + Type.getTypeName(other.getType()));
    }

    public Date getDate() {
        return this.calendar.toGregorianCalendar().getTime();
    }
}

