/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;
import org.exist.xquery.value.YearMonthDurationValue;

public class DurationValue
extends ComputableValue {
    public static final int YEAR = 0;
    public static final int MONTH = 1;
    public static final int DAY = 2;
    public static final int HOUR = 3;
    public static final int MINUTE = 4;
    public static final int SIGN = 5;
    protected static final BigInteger TWELVE = BigInteger.valueOf(12L);
    protected static final BigInteger TWENTY_FOUR = BigInteger.valueOf(24L);
    protected static final BigInteger SIXTY = BigInteger.valueOf(60L);
    protected static final BigDecimal SIXTY_DECIMAL = BigDecimal.valueOf(60L);
    protected static final BigDecimal ZERO_DECIMAL = BigDecimal.ZERO;
    protected static final Duration CANONICAL_ZERO_DURATION = TimeUtils.getInstance().newDuration(true, null, null, null, null, null, ZERO_DECIMAL);
    protected final Duration duration;
    private Duration canonicalDuration;

    public DurationValue(Duration duration) {
        this.duration = duration;
    }

    public DurationValue(String str) throws XPathException {
        try {
            this.duration = TimeUtils.getInstance().newDuration(StringValue.trimWhitespace(str));
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(ErrorCodes.FORG0001, "cannot construct " + Type.getTypeName(this.getItemType()) + " from \"" + str + "\"");
        }
    }

    public static DurationValue wrap(Duration duration) {
        try {
            return new DayTimeDurationValue(duration);
        }
        catch (XPathException e) {
            try {
                return new YearMonthDurationValue(duration);
            }
            catch (XPathException e2) {
                return new DurationValue(duration);
            }
        }
    }

    private static BigInteger nullIfZero(BigInteger x) {
        if (BigInteger.ZERO.compareTo(x) == 0) {
            x = null;
        }
        return x;
    }

    private static BigInteger zeroIfNull(BigInteger x) {
        if (x == null) {
            x = BigInteger.ZERO;
        }
        return x;
    }

    private static BigDecimal nullIfZero(BigDecimal x) {
        if (ZERO_DECIMAL.compareTo(x) == 0) {
            x = null;
        }
        return x;
    }

    private static BigDecimal zeroIfNull(BigDecimal x) {
        if (x == null) {
            x = ZERO_DECIMAL;
        }
        return x;
    }

    public static boolean areReallyEqual(Duration duration1, Duration duration2) {
        boolean secondsEqual = DurationValue.zeroIfNull((BigDecimal)duration1.getField(DatatypeConstants.SECONDS)).compareTo(DurationValue.zeroIfNull((BigDecimal)duration2.getField(DatatypeConstants.SECONDS))) == 0;
        return secondsEqual && duration1.getMinutes() == duration2.getMinutes() && duration1.getHours() == duration2.getHours() && duration1.getDays() == duration2.getDays() && duration1.getMonths() == duration2.getMonths() && duration1.getYears() == duration2.getYears();
    }

    public DurationValue wrap() {
        return DurationValue.wrap(this.duration);
    }

    public Duration getCanonicalDuration() {
        this.canonicalize();
        return this.canonicalDuration;
    }

    @Override
    public int getType() {
        return 53;
    }

    protected DurationValue createSameKind(Duration d) throws XPathException {
        return new DurationValue(d);
    }

    public DurationValue negate() throws XPathException {
        return this.createSameKind(this.duration.negate());
    }

    @Override
    public String getStringValue() {
        this.canonicalize();
        return this.canonicalDuration.toString();
    }

    private void canonicalize() {
        if (this.canonicalDuration != null) {
            return;
        }
        BigInteger[] r = this.monthsValue().divideAndRemainder(TWELVE);
        BigInteger years = DurationValue.nullIfZero(r[0]);
        BigInteger months = DurationValue.nullIfZero(r[1]);
        BigDecimal secondsValue = this.secondsValue();
        BigDecimal m = secondsValue.divide(SIXTY_DECIMAL, 0, 1);
        BigDecimal seconds = DurationValue.nullIfZero(secondsValue.subtract(SIXTY_DECIMAL.multiply(m)));
        r = m.toBigInteger().divideAndRemainder(SIXTY);
        BigInteger minutes = DurationValue.nullIfZero(r[1]);
        r = r[0].divideAndRemainder(TWENTY_FOUR);
        BigInteger hours = DurationValue.nullIfZero(r[1]);
        BigInteger days = DurationValue.nullIfZero(r[0]);
        this.canonicalDuration = years == null && months == null && days == null && hours == null && minutes == null && seconds == null ? this.canonicalZeroDuration() : TimeUtils.getInstance().newDuration(this.duration.getSign() >= 0, years, months, days, hours, minutes, seconds);
    }

    protected BigDecimal secondsValue() {
        return new BigDecimal(DurationValue.zeroIfNull((BigInteger)this.duration.getField(DatatypeConstants.DAYS)).multiply(TWENTY_FOUR).add(DurationValue.zeroIfNull((BigInteger)this.duration.getField(DatatypeConstants.HOURS))).multiply(SIXTY).add(DurationValue.zeroIfNull((BigInteger)this.duration.getField(DatatypeConstants.MINUTES))).multiply(SIXTY)).add(DurationValue.zeroIfNull((BigDecimal)this.duration.getField(DatatypeConstants.SECONDS)));
    }

    protected BigDecimal secondsValueSigned() {
        BigDecimal x = this.secondsValue();
        if (this.duration.getSign() < 0) {
            x = x.negate();
        }
        return x;
    }

    protected BigInteger monthsValue() {
        return DurationValue.zeroIfNull((BigInteger)this.duration.getField(DatatypeConstants.YEARS)).multiply(TWELVE).add(DurationValue.zeroIfNull((BigInteger)this.duration.getField(DatatypeConstants.MONTHS)));
    }

    protected BigInteger monthsValueSigned() {
        BigInteger x = this.monthsValue();
        if (this.duration.getSign() < 0) {
            x = x.negate();
        }
        return x;
    }

    protected Duration canonicalZeroDuration() {
        return CANONICAL_ZERO_DURATION;
    }

    public int getPart(int part) {
        int r;
        switch (part) {
            case 0: {
                r = this.duration.getYears();
                break;
            }
            case 1: {
                r = this.duration.getMonths();
                break;
            }
            case 2: {
                r = this.duration.getDays();
                break;
            }
            case 3: {
                r = this.duration.getHours();
                break;
            }
            case 4: {
                r = this.duration.getMinutes();
                break;
            }
            case 5: {
                return this.duration.getSign();
            }
            default: {
                throw new IllegalArgumentException("Invalid argument to method getPart");
            }
        }
        return r * this.duration.getSign();
    }

    public double getSeconds() {
        Number n = this.duration.getField(DatatypeConstants.SECONDS);
        return n == null ? 0.0 : n.doubleValue() * (double)this.duration.getSign();
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        this.canonicalize();
        switch (requiredType) {
            case 11: 
            case 20: 
            case 53: {
                return new DurationValue(this.canonicalDuration);
            }
            case 54: {
                if (this.canonicalDuration.getField(DatatypeConstants.YEARS) != null || this.canonicalDuration.getField(DatatypeConstants.MONTHS) != null) {
                    return new YearMonthDurationValue(TimeUtils.getInstance().newDurationYearMonth(this.canonicalDuration.getSign() >= 0, (BigInteger)this.canonicalDuration.getField(DatatypeConstants.YEARS), (BigInteger)this.canonicalDuration.getField(DatatypeConstants.MONTHS)));
                }
                return new YearMonthDurationValue(YearMonthDurationValue.CANONICAL_ZERO_DURATION);
            }
            case 55: {
                if (this.canonicalDuration.isSet(DatatypeConstants.DAYS) || this.canonicalDuration.isSet(DatatypeConstants.HOURS) || this.canonicalDuration.isSet(DatatypeConstants.MINUTES) || this.canonicalDuration.isSet(DatatypeConstants.SECONDS)) {
                    return new DayTimeDurationValue(TimeUtils.getInstance().newDuration(this.canonicalDuration.getSign() >= 0, null, null, (BigInteger)this.canonicalDuration.getField(DatatypeConstants.DAYS), (BigInteger)this.canonicalDuration.getField(DatatypeConstants.HOURS), (BigInteger)this.canonicalDuration.getField(DatatypeConstants.MINUTES), (BigDecimal)this.canonicalDuration.getField(DatatypeConstants.SECONDS)));
                }
                return new DayTimeDurationValue(DayTimeDurationValue.CANONICAL_ZERO_DURATION);
            }
            case 22: {
                this.canonicalize();
                return new StringValue(this.getStringValue());
            }
            case 21: {
                this.canonicalize();
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast ' + Type.getTypeName(getType()) 'to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        switch (operator) {
            case EQ: {
                if (!DurationValue.class.isAssignableFrom(other.getClass())) {
                    throw new XPathException(ErrorCodes.XPTY0004, "invalid operand type: " + Type.getTypeName(other.getType()));
                }
                boolean r = this.duration.equals(((DurationValue)other).duration);
                if (r) {
                    r &= DurationValue.areReallyEqual(this.getCanonicalDuration(), ((DurationValue)other).getCanonicalDuration());
                }
                return r;
            }
            case NEQ: {
                if (!DurationValue.class.isAssignableFrom(other.getClass())) {
                    throw new XPathException(ErrorCodes.XPTY0004, "invalid operand type: " + Type.getTypeName(other.getType()));
                }
                boolean r = this.duration.equals(((DurationValue)other).duration);
                if (r) {
                    r &= DurationValue.areReallyEqual(this.getCanonicalDuration(), ((DurationValue)other).getCanonicalDuration());
                }
                return !r;
            }
            case LT: 
            case LTEQ: 
            case GT: 
            case GTEQ: {
                throw new XPathException(ErrorCodes.XPTY0004, Type.getTypeName(other.getType()) + " type can not be ordered");
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator");
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (!DurationValue.class.isAssignableFrom(other.getClass())) {
            throw new XPathException(ErrorCodes.XPTY0004, "invalid operand type: " + Type.getTypeName(other.getType()));
        }
        return this.duration.compare(((DurationValue)other).duration);
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public ComputableValue mult(ComputableValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public ComputableValue div(ComputableValue other) throws XPathException {
        throw new XPathException(ErrorCodes.XPTY0004, "invalid operation on " + Type.getTypeName(this.getType()));
    }

    @Override
    public int conversionPreference(Class<?> target) {
        if (target.isAssignableFrom(this.getClass())) {
            return 0;
        }
        if (target.isAssignableFrom(Duration.class)) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (target.isAssignableFrom(Duration.class)) {
            return (T)this.duration;
        }
        throw new XPathException(ErrorCodes.XPTY0004, "cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException(ErrorCodes.FORG0006, "value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (DurationValue.class.isAssignableFrom(obj.getClass())) {
            return this.duration.equals(((DurationValue)obj).duration);
        }
        return false;
    }
}

