/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Optimizer;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.Type;

public class FunctionReference
extends AtomicValue {
    private static final Logger LOG = LogManager.getLogger(FunctionReference.class);
    protected FunctionCall functionCall;

    public FunctionReference(FunctionCall fcall) {
        this.functionCall = fcall;
    }

    public FunctionCall getCall() {
        return this.functionCall;
    }

    public FunctionSignature getSignature() {
        return this.functionCall.getSignature();
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        this.functionCall.analyze(contextInfo);
        if (this.functionCall.getContext().optimizationsEnabled()) {
            Optimizer optimizer = new Optimizer(this.functionCall.getContext());
            this.functionCall.accept(optimizer);
            if (optimizer.hasOptimized()) {
                this.functionCall.resetState(true);
                this.functionCall.analyze(contextInfo);
            }
        }
    }

    public Sequence eval(Sequence contextSequence) throws XPathException {
        return this.functionCall.eval(contextSequence);
    }

    public Sequence evalFunction(Sequence contextSequence, Item contextItem, Sequence[] seq) throws XPathException {
        return this.functionCall.evalFunction(contextSequence, contextItem, seq);
    }

    public void setArguments(List<Expression> arguments) throws XPathException {
        this.functionCall.setArguments(arguments);
    }

    public void setContext(XQueryContext context) {
        this.functionCall.setContext(context);
    }

    public void resetState(boolean postOptimization) {
        this.functionCall.resetState(postOptimization);
    }

    @Override
    public int getType() {
        return 101;
    }

    @Override
    public String getStringValue() throws XPathException {
        return "";
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        if (requiredType == 101) {
            return this;
        }
        throw new XPathException("cannot convert function reference to " + Type.getTypeName(requiredType));
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException(ErrorCodes.FORG0006, "Effective boolean value is not defined for a FunctionReference");
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare function reference to " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("cannot compare function reference to " + Type.getTypeName(other.getType()));
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare function references");
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        throw new XPathException("Invalid argument to aggregate function: cannot compare function references");
    }

    @Override
    public AtomicValue atomize() throws XPathException {
        throw new XPathException(ErrorCodes.FOTY0013, "A function item other than an array cannot be atomized");
    }
}

