/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class GDayValue
extends AbstractDateTimeValue {
    public GDayValue() throws XPathException {
        super(GDayValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public GDayValue(XMLGregorianCalendar calendar) throws XPathException {
        super(GDayValue.stripCalendar((XMLGregorianCalendar)calendar.clone()));
    }

    public GDayValue(String timeValue) throws XPathException {
        super(timeValue);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.GDAY) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:gDay instance must not have year, month or day fields set");
        }
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar = (XMLGregorianCalendar)calendar.clone();
        calendar.setYear(Integer.MIN_VALUE);
        calendar.setMonth(Integer.MIN_VALUE);
        calendar.setHour(Integer.MIN_VALUE);
        calendar.setMinute(Integer.MIN_VALUE);
        calendar.setSecond(Integer.MIN_VALUE);
        calendar.setMillisecond(Integer.MIN_VALUE);
        return calendar;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 58: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:time to " + Type.getTypeName(requiredType));
    }

    @Override
    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new GDayValue(cal);
    }

    @Override
    public int getType() {
        return 58;
    }

    @Override
    protected QName getXMLSchemaType() {
        return DatatypeConstants.GDAY;
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException("Subtraction is not supported on values of type " + Type.getTypeName(this.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == this.getType()) {
            if (!this.getTimezone().isEmpty() ? (!((AbstractDateTimeValue)other).getTimezone().isEmpty() ? !((DayTimeDurationValue)this.getTimezone().itemAt(0)).compareTo(null, Constants.Comparison.EQ, (DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0)) : !"PT0S".equals(((DayTimeDurationValue)this.getTimezone().itemAt(0)).getStringValue())) : !((AbstractDateTimeValue)other).getTimezone().isEmpty() && !"PT0S".equals(((DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0)).getStringValue())) {
                return -1;
            }
            int r = this.getImplicitCalendar().compare(((AbstractDateTimeValue)other).getImplicitCalendar());
            if (r == 2) {
                throw new RuntimeException("indeterminate order between " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException("Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }
}

