/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.Constants;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class GMonthValue
extends AbstractDateTimeValue {
    protected boolean addTrailingZ = false;

    public GMonthValue() throws XPathException {
        super(GMonthValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public GMonthValue(XMLGregorianCalendar calendar) throws XPathException {
        super(GMonthValue.stripCalendar((XMLGregorianCalendar)calendar.clone()));
    }

    public GMonthValue(String timeValue) throws XPathException {
        super(GMonthValue.fixTimezone(timeValue));
        timeValue = timeValue.trim();
        if (timeValue.endsWith("Z")) {
            this.addTrailingZ = true;
        }
        if (timeValue.endsWith("-00:00")) {
            this.addTrailingZ = true;
        }
        if (timeValue.endsWith("+00:00")) {
            this.addTrailingZ = true;
        }
        if (this.addTrailingZ) {
            this.calendar.setTimezone(0);
        }
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.GMONTH) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:gMonth instance must not have year, month or day fields set");
        }
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar = (XMLGregorianCalendar)calendar.clone();
        calendar.setYear(Integer.MIN_VALUE);
        calendar.setDay(Integer.MIN_VALUE);
        calendar.setHour(Integer.MIN_VALUE);
        calendar.setMinute(Integer.MIN_VALUE);
        calendar.setSecond(Integer.MIN_VALUE);
        calendar.setMillisecond(Integer.MIN_VALUE);
        return calendar;
    }

    private static String fixTimezone(String value) {
        int p = value.indexOf(90);
        if (p != -1) {
            return value.substring(0, p);
        }
        p = value.indexOf("-00:00");
        if (p != -1) {
            return value.substring(0, p);
        }
        p = value.indexOf("+00:00");
        if (p != -1) {
            return value.substring(0, p);
        }
        return value;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 57: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:gMonth to " + Type.getTypeName(requiredType));
    }

    @Override
    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new GMonthValue(cal);
    }

    @Override
    public int getType() {
        return 57;
    }

    @Override
    protected QName getXMLSchemaType() {
        return DatatypeConstants.GMONTH;
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        throw new XPathException("Subtraction is not supported on values of type " + Type.getTypeName(this.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (other.getType() == this.getType()) {
            if (!this.getTimezone().isEmpty() ? (!((AbstractDateTimeValue)other).getTimezone().isEmpty() ? !((DayTimeDurationValue)this.getTimezone().itemAt(0)).compareTo(null, Constants.Comparison.EQ, (DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0)) : !"PT0S".equals(((DayTimeDurationValue)this.getTimezone().itemAt(0)).getStringValue())) : !((AbstractDateTimeValue)other).getTimezone().isEmpty() && !"PT0S".equals(((DayTimeDurationValue)((AbstractDateTimeValue)other).getTimezone().itemAt(0)).getStringValue())) {
                return -1;
            }
            int r = this.getImplicitCalendar().compare(((AbstractDateTimeValue)other).getImplicitCalendar());
            if (r == 2) {
                throw new RuntimeException("indeterminate order between " + this + " and " + other);
            }
            return r;
        }
        throw new XPathException("Type error: cannot compare " + Type.getTypeName(this.getType()) + " to " + Type.getTypeName(other.getType()));
    }
}

