/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DecimalValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FloatValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class IntegerValue
extends NumericValue {
    public static final IntegerValue ZERO = new IntegerValue(0L);
    private static final BigInteger ZERO_BIGINTEGER = new BigInteger("0");
    private static final BigInteger ONE_BIGINTEGER = new BigInteger("1");
    private static final BigInteger MINUS_ONE_BIGINTEGER = new BigInteger("-1");
    private static final BigInteger LARGEST_LONG = new BigInteger("9223372036854775807");
    private static final BigInteger SMALLEST_LONG = new BigInteger("-9223372036854775808");
    private static final BigInteger LARGEST_UNSIGNED_LONG = new BigInteger("18446744073709551615");
    private static final BigInteger LARGEST_INT = new BigInteger("2147483647");
    private static final BigInteger SMALLEST_INT = new BigInteger("-2147483648");
    private static final BigInteger LARGEST_UNSIGNED_INT = new BigInteger("4294967295");
    private static final BigInteger LARGEST_SHORT = new BigInteger("32767");
    private static final BigInteger SMALLEST_SHORT = new BigInteger("-32768");
    private static final BigInteger LARGEST_UNSIGNED_SHORT = new BigInteger("65535");
    private static final BigInteger LARGEST_BYTE = new BigInteger("127");
    private static final BigInteger SMALLEST_BYTE = new BigInteger("-128");
    private static final BigInteger LARGEST_UNSIGNED_BYTE = new BigInteger("255");
    private BigInteger value;
    private int type = 31;

    public IntegerValue(long value) {
        this.value = BigInteger.valueOf(value);
    }

    public IntegerValue(long value, int type) throws XPathException {
        this(value);
        this.type = type;
        if (!IntegerValue.checkType(value, type)) {
            throw new XPathException("Value is not a valid integer for type " + Type.getTypeName(type));
        }
    }

    public IntegerValue(String stringValue) throws XPathException {
        try {
            this.value = new BigInteger(StringValue.trimWhitespace(stringValue));
        }
        catch (NumberFormatException e) {
            throw new XPathException(ErrorCodes.FORG0001, "failed to convert '" + stringValue + "' to an integer: " + e.getMessage(), (Throwable)e);
        }
    }

    public IntegerValue(String stringValue, int requiredType) throws XPathException {
        this.type = requiredType;
        try {
            this.value = new BigInteger(StringValue.trimWhitespace(stringValue));
            if (!this.checkType(this.value, this.type)) {
                throw new XPathException(ErrorCodes.FORG0001, "can not convert '" + stringValue + "' to " + Type.getTypeName(this.type));
            }
        }
        catch (NumberFormatException e) {
            throw new XPathException(ErrorCodes.FORG0001, "can not convert '" + stringValue + "' to " + Type.getTypeName(this.type));
        }
    }

    public IntegerValue(BigInteger value, int requiredType) {
        this.value = value;
        this.type = requiredType;
    }

    public IntegerValue(BigInteger integer) {
        this.value = integer;
    }

    private static final boolean checkType(long value, int type) throws XPathException {
        switch (type) {
            case 31: 
            case 32: 
            case 37: {
                return true;
            }
            case 35: {
                return value < 1L;
            }
            case 36: {
                return value < 0L;
            }
            case 38: {
                return value >= -4294967295L && value <= 0xFFFFFFFFL;
            }
            case 39: {
                return value >= -65535L && value <= 65535L;
            }
            case 40: {
                return value >= -255L && value <= 255L;
            }
            case 41: {
                return value > -1L;
            }
            case 42: {
                return value > -1L;
            }
            case 43: {
                return value > -1L && value <= 0xFFFFFFFFL;
            }
            case 44: {
                return value > -1L && value <= 65535L;
            }
            case 45: {
                return value > -1L && value <= 255L;
            }
            case 46: {
                return value > 0L;
            }
        }
        throw new XPathException("Unknown type: " + Type.getTypeName(type));
    }

    private boolean checkType(BigInteger value2, int type2) throws XPathException {
        switch (this.type) {
            case 37: {
                return this.value.compareTo(SMALLEST_LONG) >= 0 && this.value.compareTo(LARGEST_LONG) <= 0;
            }
            case 42: {
                return this.value.compareTo(ZERO_BIGINTEGER) >= 0 && this.value.compareTo(LARGEST_UNSIGNED_LONG) <= 0;
            }
            case 31: 
            case 32: {
                return true;
            }
            case 46: {
                return this.value.compareTo(ZERO_BIGINTEGER) == 1;
            }
            case 41: {
                return this.value.compareTo(MINUS_ONE_BIGINTEGER) == 1;
            }
            case 36: {
                return this.value.compareTo(ZERO_BIGINTEGER) == -1;
            }
            case 35: {
                return this.value.compareTo(ONE_BIGINTEGER) == -1;
            }
            case 38: {
                return this.value.compareTo(SMALLEST_INT) >= 0 && this.value.compareTo(LARGEST_INT) <= 0;
            }
            case 43: {
                return this.value.compareTo(ZERO_BIGINTEGER) >= 0 && this.value.compareTo(LARGEST_UNSIGNED_INT) <= 0;
            }
            case 39: {
                return this.value.compareTo(SMALLEST_SHORT) >= 0 && this.value.compareTo(LARGEST_SHORT) <= 0;
            }
            case 44: {
                return this.value.compareTo(ZERO_BIGINTEGER) >= 0 && this.value.compareTo(LARGEST_UNSIGNED_SHORT) <= 0;
            }
            case 40: {
                return this.value.compareTo(SMALLEST_BYTE) >= 0 && this.value.compareTo(LARGEST_BYTE) <= 0;
            }
            case 45: {
                return this.value.compareTo(ZERO_BIGINTEGER) >= 0 && this.value.compareTo(LARGEST_UNSIGNED_BYTE) <= 0;
            }
        }
        throw new XPathException("Unknown type: " + Type.getTypeName(this.type));
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean hasFractionalPart() {
        return false;
    }

    @Override
    public Item itemAt(int pos) {
        return pos == 0 ? this : null;
    }

    public long getValue() {
        return this.value.longValue();
    }

    public void setValue(long value) {
        this.value = BigInteger.valueOf(value);
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public boolean isNaN() {
        return false;
    }

    @Override
    public boolean isInfinite() {
        return false;
    }

    @Override
    public boolean isZero() {
        return this.value.signum() == 0;
    }

    @Override
    public boolean isNegative() {
        return this.value.signum() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.value.signum() > 0;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        if (this.type == requiredType) {
            return this;
        }
        switch (requiredType) {
            case 11: 
            case 20: {
                return this;
            }
            case 32: {
                return new DecimalValue(new BigDecimal(this.value));
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
            case 30: 
            case 31: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                return new IntegerValue(this.value, requiredType);
            }
            case 34: {
                return new DoubleValue(this.value.doubleValue());
            }
            case 33: {
                return new FloatValue(this.value.floatValue());
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 23: {
                return this.value.compareTo(ZERO_BIGINTEGER) == 0 ? BooleanValue.FALSE : BooleanValue.TRUE;
            }
        }
        throw new XPathException(ErrorCodes.FORG0001, "cannot convert '" + Type.getTypeName(this.getType()) + " (" + this.value + ")' into " + Type.getTypeName(requiredType));
    }

    @Override
    public int getInt() throws XPathException {
        return this.value.intValue();
    }

    @Override
    public long getLong() throws XPathException {
        return this.value.longValue();
    }

    @Override
    public double getDouble() throws XPathException {
        return this.value.doubleValue();
    }

    @Override
    public NumericValue ceiling() throws XPathException {
        return this;
    }

    @Override
    public NumericValue floor() throws XPathException {
        return this;
    }

    @Override
    public NumericValue round() throws XPathException {
        return this;
    }

    @Override
    public NumericValue round(IntegerValue precision) throws XPathException {
        if (precision == null) {
            return this.round();
        }
        if (precision.getInt() <= 0) {
            return (IntegerValue)((DecimalValue)this.convertTo(32)).round(precision).convertTo(31);
        }
        return this;
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.subtract(((IntegerValue)other).value), this.type);
        }
        return ((ComputableValue)this.convertTo(other.getType())).minus(other);
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.add(((IntegerValue)other).value), this.type);
        }
        return ((ComputableValue)this.convertTo(other.getType())).plus(other);
    }

    @Override
    public ComputableValue mult(ComputableValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.multiply(((IntegerValue)other).value), this.type);
        }
        if (Type.subTypeOf(other.getType(), 53)) {
            return other.mult(this);
        }
        return ((ComputableValue)this.convertTo(other.getType())).mult(other);
    }

    @Override
    public ComputableValue div(ComputableValue other) throws XPathException {
        if (other instanceof IntegerValue) {
            if (((IntegerValue)other).isZero()) {
                throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
            }
            BigDecimal d = new BigDecimal(this.value);
            BigDecimal od = new BigDecimal(((IntegerValue)other).value);
            int scale = Math.max(18, Math.max(d.scale(), od.scale()));
            return new DecimalValue(d.divide(od, scale, 5));
        }
        return ((ComputableValue)this.convertTo(other.getType())).div(other);
    }

    @Override
    public IntegerValue idiv(NumericValue other) throws XPathException {
        if (other.isZero()) {
            throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
        }
        ComputableValue result = this.div(other);
        return new IntegerValue(((IntegerValue)result.convertTo(31)).getLong());
    }

    @Override
    public NumericValue mod(NumericValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            if (other.isZero()) {
                throw new XPathException(ErrorCodes.FOAR0001, "division by zero");
            }
            BigInteger ov = ((IntegerValue)other).value;
            return new IntegerValue(this.value.remainder(ov), this.type);
        }
        return ((NumericValue)this.convertTo(other.getType())).mod(other);
    }

    @Override
    public NumericValue negate() throws XPathException {
        return new IntegerValue(this.value.negate());
    }

    @Override
    public NumericValue abs() throws XPathException {
        return new IntegerValue(this.value.abs(), this.type);
    }

    @Override
    public AtomicValue max(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.max(((IntegerValue)other).value));
        }
        return this.convertTo(other.getType()).max(collator, other);
    }

    @Override
    public AtomicValue min(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 31)) {
            return new IntegerValue(this.value.min(((IntegerValue)other).value));
        }
        return this.convertTo(other.getType()).min(collator, other);
    }

    @Override
    public int conversionPreference(Class<?> javaClass) {
        if (javaClass.isAssignableFrom(IntegerValue.class)) {
            return 0;
        }
        if (javaClass == Long.class || javaClass == Long.TYPE) {
            return 1;
        }
        if (javaClass == Integer.class || javaClass == Integer.TYPE) {
            return 2;
        }
        if (javaClass == Short.class || javaClass == Short.TYPE) {
            return 3;
        }
        if (javaClass == Byte.class || javaClass == Byte.TYPE) {
            return 4;
        }
        if (javaClass == Double.class || javaClass == Double.TYPE) {
            return 5;
        }
        if (javaClass == Float.class || javaClass == Float.TYPE) {
            return 6;
        }
        if (javaClass == String.class) {
            return 7;
        }
        if (javaClass == Boolean.class || javaClass == Boolean.TYPE) {
            return 8;
        }
        if (javaClass == Object.class) {
            return 20;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public <T> T toJavaObject(Class<T> target) throws XPathException {
        if (target.isAssignableFrom(IntegerValue.class)) {
            return (T)this;
        }
        if (target == Long.class || target == Long.TYPE) {
            return (T)Long.valueOf(this.value.longValue());
        }
        if (target == Integer.class || target == Integer.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(38);
            return (T)Integer.valueOf(v.value.intValue());
        }
        if (target == Short.class || target == Short.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(39);
            return (T)Short.valueOf(v.value.shortValue());
        }
        if (target == Byte.class || target == Byte.TYPE) {
            IntegerValue v = (IntegerValue)this.convertTo(40);
            return (T)Byte.valueOf(v.value.byteValue());
        }
        if (target == Double.class || target == Double.TYPE) {
            DoubleValue v = (DoubleValue)this.convertTo(34);
            return (T)Double.valueOf(v.getValue());
        }
        if (target == Float.class || target == Float.TYPE) {
            FloatValue v = (FloatValue)this.convertTo(33);
            return (T)Float.valueOf(v.value);
        }
        if (target == Boolean.class || target == Boolean.TYPE) {
            return (T)new BooleanValue(this.effectiveBooleanValue());
        }
        if (target == String.class) {
            return (T)this.value.toString();
        }
        if (target == BigInteger.class) {
            return (T)new BigInteger(this.value.toByteArray());
        }
        if (target == Object.class) {
            return (T)this.value;
        }
        throw new XPathException("cannot convert value of type " + Type.getTypeName(this.getType()) + " to Java object of type " + target.getName());
    }

    @Override
    public int compareTo(Object o) {
        AtomicValue other = (AtomicValue)o;
        if (Type.subTypeOf(other.getType(), 31)) {
            return this.value.compareTo(((IntegerValue)other).value);
        }
        return this.getType() > other.getType() ? 1 : -1;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

