/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import com.ibm.icu.text.Collator;
import org.exist.xquery.Constants;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Type;

public abstract class NumericValue
extends ComputableValue {
    @Override
    public abstract String getStringValue() throws XPathException;

    @Override
    public abstract AtomicValue convertTo(int var1) throws XPathException;

    public double getDouble() throws XPathException {
        return ((DoubleValue)this.convertTo(34)).getValue();
    }

    public long getLong() throws XPathException {
        return ((IntegerValue)this.convertTo(31)).getValue();
    }

    public int getInt() throws XPathException {
        return (int)((IntegerValue)this.convertTo(31)).getValue();
    }

    public abstract boolean hasFractionalPart();

    public abstract boolean isNaN();

    public abstract boolean isInfinite();

    public abstract boolean isZero();

    public abstract boolean isNegative();

    public abstract boolean isPositive();

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        return !this.isNaN() && !this.isZero();
    }

    @Override
    public boolean compareTo(Collator collator, Constants.Comparison operator, AtomicValue other) throws XPathException {
        if (other.isEmpty()) {
            return false;
        }
        if (Type.subTypeOf(other.getType(), 30)) {
            if (this.isNaN() && ((NumericValue)other).isNaN()) {
                return operator == Constants.Comparison.NEQ;
            }
            double otherVal = ((NumericValue)other).getDouble();
            double val = this.getDouble();
            switch (operator) {
                case EQ: {
                    return val == otherVal;
                }
                case NEQ: {
                    return val != otherVal;
                }
                case GT: {
                    return val > otherVal;
                }
                case GTEQ: {
                    return val >= otherVal;
                }
                case LT: {
                    return val < otherVal;
                }
                case LTEQ: {
                    return val <= otherVal;
                }
            }
            throw new XPathException("Type error: cannot apply operator to numeric value");
        }
        throw new XPathException(ErrorCodes.XPTY0004, "Type error: cannot compare operands: " + Type.getTypeName(this.getType()) + " and " + Type.getTypeName(other.getType()));
    }

    @Override
    public int compareTo(Collator collator, AtomicValue other) throws XPathException {
        if (Type.subTypeOf(other.getType(), 30)) {
            if (this.isNaN() && ((NumericValue)other).isNaN()) {
                return -1;
            }
            double otherVal = ((NumericValue)other).getDouble();
            double val = this.getDouble();
            if (val == otherVal) {
                return 0;
            }
            if (val > otherVal) {
                return 1;
            }
            return -1;
        }
        throw new XPathException("cannot compare numeric value to non-numeric value");
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (NumericValue.class.isAssignableFrom(obj.getClass())) {
            try {
                return this.compareTo(null, Constants.Comparison.EQ, (NumericValue)obj);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        return false;
    }

    public abstract NumericValue negate() throws XPathException;

    public abstract NumericValue ceiling() throws XPathException;

    public abstract NumericValue floor() throws XPathException;

    public abstract NumericValue round() throws XPathException;

    public abstract NumericValue round(IntegerValue var1) throws XPathException;

    public abstract NumericValue mod(NumericValue var1) throws XPathException;

    public abstract IntegerValue idiv(NumericValue var1) throws XPathException;

    public abstract NumericValue abs() throws XPathException;

    @Override
    public abstract AtomicValue max(Collator var1, AtomicValue var2) throws XPathException;

    @Override
    public abstract AtomicValue min(Collator var1, AtomicValue var2) throws XPathException;
}

