/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Objects;
import java.util.stream.Stream;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.AVLTreeNodeSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.numbering.NodeId;
import org.exist.xquery.OrderSpec;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.ValueSequence;

public class OrderedValueSequence
extends AbstractSequence {
    private final OrderSpec[] orderSpecs;
    private Entry[] items = null;
    private int count = 0;
    private int state = 0;
    private int itemType = 12;

    public OrderedValueSequence(OrderSpec[] orderSpecs, int size) {
        this.orderSpecs = orderSpecs;
        if (size == 0) {
            size = 1;
        }
        this.items = new Entry[size];
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        return new OrderedValueSequenceIterator();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        return new OrderedValueSequenceIterator();
    }

    @Override
    public int getItemCount() {
        return this.items == null ? 0 : this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public boolean hasOne() {
        return this.hasOne;
    }

    @Override
    public void add(Item item) throws XPathException {
        if (this.hasOne) {
            this.hasOne = false;
        }
        if (this.isEmpty) {
            this.hasOne = true;
        }
        this.isEmpty = false;
        if (this.count == 0 && this.items.length == 1) {
            this.items = new Entry[2];
        } else if (this.count == this.items.length) {
            Entry[] newItems = new Entry[this.count * 2];
            System.arraycopy(this.items, 0, newItems, 0, this.count);
            this.items = newItems;
        }
        this.items[this.count] = new Entry(item, this.count++);
        this.checkItemType(item.getType());
        this.setHasChanged();
    }

    @Override
    public void addAll(Sequence other) throws XPathException {
        if (other.hasOne()) {
            this.add(other.itemAt(0));
        } else if (!other.isEmpty()) {
            SequenceIterator i = other.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (next == null) continue;
                this.add(next);
            }
        }
    }

    public void sort() {
        this.items = (Entry[])((Stream)Stream.of(this.items).filter(Objects::nonNull).parallel()).sorted().map(entry -> {
            entry.clear();
            return entry;
        }).toArray(Entry[]::new);
    }

    @Override
    public Item itemAt(int pos) {
        if (this.items != null && pos > -1 && pos < this.count) {
            return this.items[pos].item;
        }
        return null;
    }

    private void checkItemType(int type) {
        if (this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : Type.getCommonSuperType(type, this.itemType);
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        if (this.isEmpty()) {
            return NodeSet.EMPTY_SET;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            AVLTreeNodeSet set = new AVLTreeNodeSet();
            for (int i = 0; i < this.items.length; ++i) {
                if (this.items[i] == null) continue;
                NodeValue v = (NodeValue)this.items[i].item;
                if (v.getImplementationType() != 1) {
                    org.exist.dom.memtree.DocumentImpl doc;
                    org.exist.dom.memtree.DocumentImpl documentImpl = doc = v.getType() == 6 ? (org.exist.dom.memtree.DocumentImpl)v : ((NodeImpl)v).getOwnerDocument();
                    if (doc == null) continue;
                    org.exist.dom.memtree.DocumentImpl expandedDoc = doc.expandRefs(null);
                    DocumentImpl newDoc = expandedDoc.makePersistent();
                    if (newDoc != null) {
                        NodeId rootId = newDoc.getBrokerPool().getNodeFactory().createInstance();
                        for (int j = i; j < this.count; ++j) {
                            org.exist.dom.memtree.DocumentImpl nodeOwnerDoc;
                            v = (NodeValue)this.items[j].item;
                            if (v.getImplementationType() == 1) continue;
                            NodeImpl node = (NodeImpl)v;
                            org.exist.dom.memtree.DocumentImpl documentImpl2 = nodeOwnerDoc = node.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)v : ((NodeImpl)v).getOwnerDocument();
                            if (nodeOwnerDoc != doc) continue;
                            NodeId nodeId = (node = expandedDoc.getNode(node.getNodeNumber())).getNodeId();
                            if (nodeId == null) {
                                throw new XPathException("Internal error: nodeId == null");
                            }
                            nodeId = node.getNodeType() == 9 ? rootId : rootId.append(nodeId);
                            NodeProxy p = new NodeProxy(newDoc, nodeId, node.getNodeType());
                            if (p == null) continue;
                            this.items[j].item = p;
                        }
                    }
                    set.add((NodeProxy)this.items[i].item);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    @Override
    public boolean isPersistentSet() {
        if (this.count == 0) {
            return true;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            for (int i = 0; i < this.count; ++i) {
                NodeValue v = (NodeValue)this.items[i].item;
                if (v.getImplementationType() == 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        if (this.count == 0) {
            return MemoryNodeSet.EMPTY;
        }
        if (this.itemType == 12 || !Type.subTypeOf(this.itemType, -1)) {
            throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
        }
        for (int i = 0; i < this.count; ++i) {
            NodeValue v = (NodeValue)this.items[i].item;
            if (v.getImplementationType() != 1) continue;
            return null;
        }
        return new ValueSequence(this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            builder.append(this.items[i].toString());
        }
        return builder.toString();
    }

    @Override
    public void removeDuplicates() {
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? (this.state = 0) : this.state + 1;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    private class OrderedValueSequenceIterator
    implements SequenceIterator {
        int pos = 0;

        private OrderedValueSequenceIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pos < OrderedValueSequence.this.count;
        }

        @Override
        public Item nextItem() {
            if (this.pos < OrderedValueSequence.this.count) {
                return ((OrderedValueSequence)OrderedValueSequence.this).items[this.pos++].item;
            }
            return null;
        }
    }

    private class Entry
    implements Comparable<Entry> {
        Item item;
        AtomicValue[] values;
        int pos;

        public Entry(Item item, int position) throws XPathException {
            this.item = item;
            this.pos = position;
            this.values = new AtomicValue[OrderedValueSequence.this.orderSpecs.length];
            for (int i = 0; i < OrderedValueSequence.this.orderSpecs.length; ++i) {
                Sequence seq = OrderedValueSequence.this.orderSpecs[i].getSortExpression().eval(null);
                this.values[i] = AtomicValue.EMPTY_VALUE;
                if (seq.hasOne()) {
                    this.values[i] = seq.itemAt(0).atomize();
                    continue;
                }
                if (!seq.hasMany()) continue;
                throw new XPathException("expected a single value for order expression " + ExpressionDumper.dump(OrderedValueSequence.this.orderSpecs[i].getSortExpression()) + " ; found: " + seq.getItemCount());
            }
        }

        @Override
        public int compareTo(Entry other) {
            int cmp = 0;
            for (int i = 0; i < this.values.length; ++i) {
                try {
                    boolean bIsEmpty;
                    AtomicValue a = this.values[i];
                    AtomicValue b = other.values[i];
                    boolean aIsEmpty = a.isEmpty() || Type.subTypeOf(a.getType(), 30) && ((NumericValue)a).isNaN();
                    boolean bl = bIsEmpty = b.isEmpty() || Type.subTypeOf(b.getType(), 30) && ((NumericValue)b).isNaN();
                    if (aIsEmpty) {
                        if (bIsEmpty) {
                            return 0;
                        }
                        cmp = (OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1;
                    } else {
                        cmp = bIsEmpty ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : (a == AtomicValue.EMPTY_VALUE && b != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? -1 : 1) : (b == AtomicValue.EMPTY_VALUE && a != AtomicValue.EMPTY_VALUE ? ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 4) != 0 ? 1 : -1) : a.compareTo(OrderedValueSequence.this.orderSpecs[i].getCollator(), b)));
                    }
                    if ((OrderedValueSequence.this.orderSpecs[i].getModifiers() & 1) != 0) {
                        cmp *= -1;
                    }
                    if (cmp == 0) continue;
                    break;
                }
                catch (XPathException xPathException) {
                    // empty catch block
                }
            }
            if (cmp == 0) {
                cmp = this.pos > other.pos ? 1 : (this.pos == other.pos ? 0 : -1);
            }
            return cmp;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.item);
            builder.append(" [");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(this.values[i].toString());
            }
            builder.append("]");
            return builder.toString();
        }

        public void clear() {
            this.values = null;
        }
    }
}

