/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractDateTimeValue;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class TimeValue
extends AbstractDateTimeValue {
    public TimeValue() throws XPathException {
        super(TimeValue.stripCalendar(TimeUtils.getInstance().newXMLGregorianCalendar(new GregorianCalendar())));
    }

    public TimeValue(XMLGregorianCalendar calendar) throws XPathException {
        super(TimeValue.stripCalendar((XMLGregorianCalendar)calendar.clone()));
    }

    public TimeValue(String timeValue) throws XPathException {
        super(timeValue);
        try {
            if (this.calendar.getXMLSchemaType() != DatatypeConstants.TIME) {
                throw new IllegalStateException();
            }
        }
        catch (IllegalStateException e) {
            throw new XPathException("xs:time instance must not have year, month or day fields set");
        }
    }

    private static XMLGregorianCalendar stripCalendar(XMLGregorianCalendar calendar) {
        calendar = (XMLGregorianCalendar)calendar.clone();
        calendar.setYear(Integer.MIN_VALUE);
        calendar.setMonth(Integer.MIN_VALUE);
        calendar.setDay(Integer.MIN_VALUE);
        return calendar;
    }

    @Override
    protected AbstractDateTimeValue createSameKind(XMLGregorianCalendar cal) throws XPathException {
        return new TimeValue(cal);
    }

    @Override
    protected QName getXMLSchemaType() {
        return DatatypeConstants.TIME;
    }

    @Override
    public int getType() {
        return 52;
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 52: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException("Type error: cannot cast xs:time to " + Type.getTypeName(requiredType));
    }

    @Override
    public ComputableValue minus(ComputableValue other) throws XPathException {
        switch (other.getType()) {
            case 52: {
                return new DayTimeDurationValue(this.getTimeInMillis() - ((TimeValue)other).getTimeInMillis());
            }
            case 55: {
                return ((DayTimeDurationValue)other).negate().plus(this);
            }
        }
        throw new XPathException("Operand to minus should be of type xs:time or xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        if (other.getType() == 55) {
            return other.plus(this);
        }
        throw new XPathException("Operand to plus should be of type xdt:dayTimeDuration; got: " + Type.getTypeName(other.getType()));
    }
}

