/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DefaultDocumentSet;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NewArrayNodeSet;
import org.exist.dom.persistent.NodeProxy;
import org.exist.dom.persistent.NodeSet;
import org.exist.dom.persistent.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.util.FastQSort;
import org.exist.xquery.NodeTest;
import org.exist.xquery.Variable;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.ItemComparator;
import org.exist.xquery.value.MemoryNodeSet;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Document;

public class ValueSequence
extends AbstractSequence
implements MemoryNodeSet {
    private static final int UNSET_SIZE = -1;
    private static final int INITIAL_SIZE = 64;
    private final Logger LOG = LogManager.getLogger(ValueSequence.class);
    protected Item[] values;
    protected int size = -1;
    protected int itemType = 12;
    private boolean noDuplicates = false;
    private boolean inMemNodeSet = false;
    private boolean isOrdered = false;
    private boolean enforceOrder = false;
    private boolean keepUnOrdered = false;
    private Variable holderVar = null;
    private int state = 0;
    private NodeSet cachedSet = null;

    public ValueSequence() {
        this(false);
    }

    public ValueSequence(boolean ordered) {
        this.values = new Item[64];
        this.enforceOrder = ordered;
    }

    public ValueSequence(int initialSize) {
        this.values = new Item[initialSize];
    }

    public ValueSequence(Sequence otherSequence) throws XPathException {
        this(otherSequence, false);
    }

    public ValueSequence(Sequence otherSequence, boolean ordered) throws XPathException {
        this.values = new Item[otherSequence.getItemCount()];
        this.addAll(otherSequence);
        this.enforceOrder = ordered;
    }

    public ValueSequence(Item ... items) throws XPathException {
        this.values = new Item[items.length];
        for (Item item : items) {
            this.add(item);
        }
    }

    public void keepUnOrdered(boolean flag) {
        this.keepUnOrdered = flag;
    }

    public void clear() {
        Arrays.fill(this.values, null);
        this.size = -1;
        this.itemType = 12;
        this.noDuplicates = false;
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public boolean hasOne() {
        return this.hasOne;
    }

    @Override
    public void add(Item item) {
        if (this.hasOne) {
            this.hasOne = false;
        }
        if (this.isEmpty) {
            this.hasOne = true;
        }
        this.cachedSet = null;
        this.isEmpty = false;
        ++this.size;
        this.ensureCapacity();
        this.values[this.size] = item;
        if (this.itemType == item.getType()) {
            return;
        }
        this.itemType = this.itemType == 12 ? item.getType() : Type.getCommonSuperType(item.getType(), this.itemType);
        this.noDuplicates = false;
        this.isOrdered = false;
        this.setHasChanged();
    }

    @Override
    public void addAll(Sequence otherSequence) throws XPathException {
        if (otherSequence == null) {
            return;
        }
        SequenceIterator iterator = otherSequence.iterate();
        if (iterator == null) {
            this.LOG.warn("Iterator == null: {}", (Object)otherSequence.getClass().getName());
        }
        while (iterator.hasNext()) {
            this.add(iterator.nextItem());
        }
    }

    @Override
    public int getItemType() {
        return this.itemType == 12 ? 11 : this.itemType;
    }

    @Override
    public SequenceIterator iterate() throws XPathException {
        this.sortInDocumentOrder();
        return new ValueSequenceIterator();
    }

    @Override
    public SequenceIterator unorderedIterator() throws XPathException {
        this.sortInDocumentOrder();
        return new ValueSequenceIterator();
    }

    public SequenceIterator iterateInReverse() throws XPathException {
        this.sortInDocumentOrder();
        return new ReverseValueSequenceIterator();
    }

    public boolean isOrdered() {
        return this.enforceOrder;
    }

    public void setIsOrdered(boolean ordered) {
        this.enforceOrder = ordered;
    }

    @Override
    public int getItemCount() {
        this.sortInDocumentOrder();
        return this.size + 1;
    }

    @Override
    public Item itemAt(int pos) {
        this.sortInDocumentOrder();
        return this.values[pos];
    }

    public void setHolderVariable(Variable var) {
        this.holderVar = var;
    }

    @Override
    public NodeSet toNodeSet() throws XPathException {
        if (this.size == -1) {
            return NodeSet.EMPTY_SET;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            NewArrayNodeSet set = new NewArrayNodeSet();
            for (int i = 0; i <= this.size; ++i) {
                NodeValue v = (NodeValue)this.values[i];
                if (v.getImplementationType() != 1) {
                    org.exist.dom.memtree.DocumentImpl expandedDoc;
                    DocumentImpl newDoc;
                    org.exist.dom.memtree.DocumentImpl doc = v.getType() == 6 ? (org.exist.dom.memtree.DocumentImpl)v : ((NodeImpl)v).getOwnerDocument();
                    if (doc == null || (newDoc = (expandedDoc = doc.expandRefs(null)).makePersistent()) == null) continue;
                    NodeId rootId = newDoc.getBrokerPool().getNodeFactory().createInstance();
                    for (int j = i; j <= this.size; ++j) {
                        NodeImpl node;
                        Document nodeOwnerDoc;
                        v = (NodeValue)this.values[j];
                        if (v.getImplementationType() == 1 || (nodeOwnerDoc = (node = (NodeImpl)v).getNodeType() == 9 ? (Document)((Object)node) : node.getOwnerDocument()) != doc) continue;
                        NodeId nodeId = (node = node.getNodeType() == 2 ? expandedDoc.getAttribute(node.getNodeNumber()) : expandedDoc.getNode(node.getNodeNumber())).getNodeId();
                        if (nodeId == null) {
                            throw new XPathException("Internal error: nodeId == null");
                        }
                        nodeId = node.getNodeType() == 9 ? rootId : rootId.append(nodeId);
                        NodeProxy p = new NodeProxy(newDoc, nodeId, node.getNodeType());
                        if (p == null) continue;
                        this.values[j] = p;
                    }
                    set.add((NodeProxy)this.values[i]);
                    continue;
                }
                set.add((NodeProxy)v);
            }
            if (this.holderVar != null) {
                this.holderVar.setValue(set);
            }
            return set;
        }
        throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
    }

    @Override
    public MemoryNodeSet toMemNodeSet() throws XPathException {
        if (this.size == -1) {
            return MemoryNodeSet.EMPTY;
        }
        if (this.itemType == 12 || !Type.subTypeOf(this.itemType, -1)) {
            throw new XPathException("Type error: the sequence cannot be converted into a node set. Item type is " + Type.getTypeName(this.itemType));
        }
        for (int i = 0; i <= this.size; ++i) {
            NodeValue v = (NodeValue)this.values[i];
            if (v.getImplementationType() != 1) continue;
            throw new XPathException("Type error: the sequence cannot be converted into a MemoryNodeSet. It contains nodes from stored resources.");
        }
        this.expand();
        this.inMemNodeSet = true;
        return this;
    }

    public boolean isInMemorySet() {
        if (this.size == -1) {
            return true;
        }
        if (this.itemType == 12 || !Type.subTypeOf(this.itemType, -1)) {
            return false;
        }
        for (int i = 0; i <= this.size; ++i) {
            NodeValue v = (NodeValue)this.values[i];
            if (v.getImplementationType() != 1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPersistentSet() {
        if (this.size == -1) {
            return true;
        }
        if (this.itemType != 12 && Type.subTypeOf(this.itemType, -1)) {
            for (int i = 0; i <= this.size; ++i) {
                NodeValue v = (NodeValue)this.values[i];
                if (v.getImplementationType() == 1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void expand() {
        HashSet<org.exist.dom.memtree.DocumentImpl> docs = new HashSet<org.exist.dom.memtree.DocumentImpl>();
        for (int i = 0; i <= this.size; ++i) {
            org.exist.dom.memtree.DocumentImpl ownerDoc;
            NodeImpl node = (NodeImpl)this.values[i];
            org.exist.dom.memtree.DocumentImpl documentImpl = ownerDoc = node.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)node : node.getOwnerDocument();
            if (!ownerDoc.hasReferenceNodes()) continue;
            docs.add(ownerDoc);
        }
        for (org.exist.dom.memtree.DocumentImpl doc : docs) {
            doc.expand();
        }
    }

    @Override
    public void destroy(XQueryContext context, Sequence contextSequence) {
        this.holderVar = null;
        for (int i = 0; i <= this.size; ++i) {
            this.values[i].destroy(context, contextSequence);
        }
    }

    public boolean containsValue(AtomicValue value) {
        for (int i = 0; i <= this.size; ++i) {
            if (this.values[i] != value) continue;
            return true;
        }
        return false;
    }

    public void sortInDocumentOrder() {
        if (this.size == -1) {
            return;
        }
        if (this.keepUnOrdered) {
            this.removeDuplicateNodes();
            return;
        }
        if (!this.enforceOrder || this.isOrdered) {
            return;
        }
        boolean bl = this.inMemNodeSet = this.inMemNodeSet || this.isInMemorySet();
        if (this.inMemNodeSet) {
            FastQSort.sort(this.values, new InMemoryNodeComparator(), 0, this.size);
        }
        this.removeDuplicateNodes();
        this.isOrdered = true;
    }

    @Override
    public void removeDuplicates() {
        this.enforceOrder = true;
        this.isOrdered = false;
        this.sortInDocumentOrder();
    }

    private void ensureCapacity() {
        if (this.size == this.values.length) {
            int newSize = (int)Math.round((double)(this.size == 0 ? 1 : this.size * 3) / 2.0);
            Item[] newValues = new Item[newSize];
            System.arraycopy(this.values, 0, newValues, 0, this.size);
            this.values = newValues;
        }
    }

    private void removeDuplicateNodes() {
        if (this.noDuplicates || this.size < 1) {
            return;
        }
        if (this.inMemNodeSet) {
            int j = 0;
            for (int i = 1; i <= this.size; ++i) {
                if (this.values[i].equals(this.values[j]) || i == ++j) continue;
                this.values[j] = this.values[i];
            }
            this.size = j;
        } else {
            if (this.itemType != 12 && Type.subTypeOf(this.itemType, 20)) {
                return;
            }
            boolean hasNodes = false;
            for (int i = 0; i <= this.size; ++i) {
                if (!Type.subTypeOf(this.values[i].getType(), -1)) continue;
                hasNodes = true;
            }
            if (!hasNodes) {
                return;
            }
            TreeMap<Item, Item> nodes = new TreeMap<Item, Item>(ItemComparator.INSTANCE);
            int j = 0;
            for (int i = 0; i <= this.size; ++i) {
                if (Type.subTypeOf(this.values[i].getType(), -1)) {
                    Item found = (Item)nodes.get(this.values[i]);
                    if (found == null) {
                        Item item = this.values[i];
                        this.values[j++] = item;
                        nodes.put(item, item);
                        continue;
                    }
                    NodeValue nv = (NodeValue)found;
                    if (nv.getImplementationType() != 1) continue;
                    ((NodeProxy)nv).addMatches((NodeProxy)this.values[i]);
                    continue;
                }
                this.values[j++] = this.values[i];
            }
            this.size = j - 1;
        }
        this.noDuplicates = true;
    }

    @Override
    public void clearContext(int contextId) throws XPathException {
        for (int i = 0; i <= this.size; ++i) {
            if (!Type.subTypeOf(this.values[i].getType(), -1)) continue;
            ((NodeValue)this.values[i]).clearContext(contextId);
        }
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
        for (int i = 0; i <= this.size; ++i) {
            this.values[i].nodeMoved(oldNodeId, newNode);
        }
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? (this.state = 0) : this.state + 1;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    @Override
    public boolean isCacheable() {
        return true;
    }

    @Override
    public DocumentSet getDocumentSet() {
        if (this.cachedSet != null) {
            return this.cachedSet.getDocumentSet();
        }
        try {
            boolean isPersistentSet = true;
            for (int i = 0; i <= this.size; ++i) {
                if (Type.subTypeOf(this.values[i].getType(), -1)) {
                    NodeValue node = (NodeValue)this.values[i];
                    if (node.getImplementationType() == 1) continue;
                    isPersistentSet = false;
                    break;
                }
                isPersistentSet = false;
                break;
            }
            if (isPersistentSet) {
                this.cachedSet = this.toNodeSet();
                return this.cachedSet.getDocumentSet();
            }
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return this.extractDocumentSet();
    }

    private DocumentSet extractDocumentSet() {
        DefaultDocumentSet docs = new DefaultDocumentSet();
        for (int i = 0; i <= this.size; ++i) {
            NodeValue node;
            if (!Type.subTypeOf(this.values[i].getType(), -1) || (node = (NodeValue)this.values[i]).getImplementationType() != 1) continue;
            docs.add((DocumentImpl)node.getOwnerDocument());
        }
        return docs;
    }

    @Override
    public Sequence getAttributes(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectAttributes(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getDescendantAttributes(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectDescendantAttributes(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getChildren(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectChildren(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getChildrenForParent(NodeImpl parent) {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (!node.getNodeId().isChildOf(parent.getNodeId())) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public Sequence getDescendants(boolean includeSelf, NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectDescendants(includeSelf, test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getAncestors(boolean includeSelf, NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectAncestors(includeSelf, test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getParents(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            NodeImpl parent = (NodeImpl)node.selectParentNode();
            if (parent == null || !test.matches(parent)) continue;
            nodes.add(parent);
        }
        return nodes;
    }

    @Override
    public Sequence getSelf(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if ((test.getType() != -1 || node.getNodeType() != 2) && !test.matches(node)) continue;
            nodes.add(node);
        }
        return nodes;
    }

    @Override
    public Sequence getPrecedingSiblings(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectPrecedingSiblings(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getPreceding(NodeTest test, int position) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectPreceding(test, nodes, position);
        }
        return nodes;
    }

    @Override
    public Sequence getFollowingSiblings(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectFollowingSiblings(test, nodes);
        }
        return nodes;
    }

    @Override
    public Sequence getFollowing(NodeTest test, int position) throws XPathException {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            node.selectFollowing(test, nodes, position);
        }
        return nodes;
    }

    @Override
    public Sequence selectDescendants(MemoryNodeSet descendants) {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            for (int j = 0; j < descendants.size(); ++j) {
                NodeImpl descendant = descendants.get(j);
                if (!descendant.getNodeId().isDescendantOrSelfOf(node.getNodeId())) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    @Override
    public Sequence selectChildren(MemoryNodeSet children) {
        this.sortInDocumentOrder();
        ValueSequence nodes = new ValueSequence(true);
        nodes.keepUnOrdered(this.keepUnOrdered);
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            for (int j = 0; j < children.size(); ++j) {
                NodeImpl descendant = children.get(j);
                if (!descendant.getNodeId().isChildOf(node.getNodeId())) continue;
                nodes.add(node);
            }
        }
        return nodes;
    }

    @Override
    public int size() {
        return this.size + 1;
    }

    @Override
    public NodeImpl get(int which) {
        return (NodeImpl)this.values[which];
    }

    @Override
    public Iterator<Collection> getCollectionIterator() {
        return new CollectionIterator();
    }

    @Override
    public String toString() {
        try {
            StringBuilder result = new StringBuilder();
            result.append("(");
            boolean moreThanOne = false;
            SequenceIterator i = this.iterate();
            while (i.hasNext()) {
                Item next = i.nextItem();
                if (moreThanOne) {
                    result.append(", ");
                }
                moreThanOne = true;
                result.append(next.toString());
            }
            result.append(")");
            return result.toString();
        }
        catch (XPathException e) {
            return "ValueSequence.toString() failed: " + e.getMessage();
        }
    }

    @Override
    public boolean matchSelf(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if ((test.getType() != -1 || node.getNodeType() != 2) && !test.matches(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchChildren(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (!node.matchChildren(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchAttributes(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (!node.matchAttributes(test)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchDescendantAttributes(NodeTest test) throws XPathException {
        this.sortInDocumentOrder();
        for (int i = 0; i <= this.size; ++i) {
            NodeImpl node = (NodeImpl)this.values[i];
            if (!node.matchDescendantAttributes(test)) continue;
            return true;
        }
        return false;
    }

    private class ReverseValueSequenceIterator
    implements SequenceIterator {
        private int pos;

        public ReverseValueSequenceIterator() {
            this.pos = ValueSequence.this.size;
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        @Override
        public Item nextItem() {
            if (this.pos >= 0) {
                return ValueSequence.this.values[this.pos--];
            }
            return null;
        }
    }

    private class ValueSequenceIterator
    implements SequenceIterator {
        private int pos = 0;

        @Override
        public boolean hasNext() {
            return this.pos <= ValueSequence.this.size;
        }

        @Override
        public Item nextItem() {
            if (this.pos <= ValueSequence.this.size) {
                return ValueSequence.this.values[this.pos++];
            }
            return null;
        }
    }

    private class CollectionIterator
    implements Iterator<Collection> {
        Collection nextCollection = null;
        int pos = 0;

        CollectionIterator() {
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.nextCollection != null;
        }

        @Override
        public Collection next() {
            Collection oldCollection = this.nextCollection;
            this.nextCollection = null;
            while (this.pos <= ValueSequence.this.size) {
                NodeProxy p;
                NodeValue node;
                if (Type.subTypeOf(ValueSequence.this.values[this.pos].getType(), -1) && (node = (NodeValue)ValueSequence.this.values[this.pos]).getImplementationType() == 1 && !(p = (NodeProxy)node).getOwnerDocument().getCollection().equals(oldCollection)) {
                    this.nextCollection = p.getOwnerDocument().getCollection();
                    break;
                }
                ++this.pos;
            }
            return oldCollection;
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    private static class InMemoryNodeComparator
    implements Comparator<Item> {
        private InMemoryNodeComparator() {
        }

        @Override
        public int compare(Item o1, Item o2) {
            org.exist.dom.memtree.DocumentImpl n2Doc;
            NodeImpl n1 = (NodeImpl)o1;
            NodeImpl n2 = (NodeImpl)o2;
            org.exist.dom.memtree.DocumentImpl n1Doc = n1.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)n1 : n1.getOwnerDocument();
            int docCmp = n1Doc.compareTo(n2Doc = n2.getNodeType() == 9 ? (org.exist.dom.memtree.DocumentImpl)n2 : n2.getOwnerDocument());
            if (docCmp == 0) {
                return n1.getNodeNumber() == n2.getNodeNumber() ? 0 : (n1.getNodeNumber() > n2.getNodeNumber() ? 1 : -1);
            }
            return docCmp;
        }
    }
}

