/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import org.exist.util.FastStringBuffer;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DayTimeDurationValue;
import org.exist.xquery.value.DurationValue;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.OrderedDurationValue;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.TimeUtils;
import org.exist.xquery.value.Type;
import org.exist.xquery.value.UntypedAtomicValue;

public class YearMonthDurationValue
extends OrderedDurationValue {
    public static final Duration CANONICAL_ZERO_DURATION = TimeUtils.getInstance().newDuration(true, null, BigInteger.ZERO, null, null, null, null);

    YearMonthDurationValue(Duration duration) throws XPathException {
        super(duration);
        if (!duration.equals(DurationValue.CANONICAL_ZERO_DURATION) && (duration.isSet(DatatypeConstants.DAYS) || duration.isSet(DatatypeConstants.HOURS) || duration.isSet(DatatypeConstants.MINUTES) || duration.isSet(DatatypeConstants.SECONDS))) {
            throw new XPathException(ErrorCodes.XPTY0004, "The value '" + duration + "' is not an " + Type.getTypeName(this.getType()) + " since it specifies days, hours, minutes or seconds values");
        }
    }

    public YearMonthDurationValue(String str) throws XPathException {
        this(YearMonthDurationValue.createDurationYearMonth(str));
    }

    private static Duration createDurationYearMonth(String str) throws XPathException {
        try {
            return TimeUtils.getInstance().newDurationYearMonth(StringValue.trimWhitespace(str));
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(ErrorCodes.FORG0001, "cannot construct " + Type.getTypeName(54) + " from \"" + str + "\"");
        }
    }

    @Override
    public DurationValue wrap() {
        return this;
    }

    @Override
    protected Duration canonicalZeroDuration() {
        return CANONICAL_ZERO_DURATION;
    }

    public int getValue() {
        return this.duration.getSign() * (this.duration.getYears() * 12 + this.duration.getMonths());
    }

    @Override
    public int getType() {
        return 54;
    }

    @Override
    public String getStringValue() {
        FastStringBuffer sb = new FastStringBuffer(32);
        if (this.getCanonicalDuration().getSign() < 0) {
            sb.append('-');
        }
        sb.append('P');
        if (this.getCanonicalDuration().getYears() != 0) {
            sb.append(this.getCanonicalDuration().getYears() + "Y");
        }
        if (this.getCanonicalDuration().getMonths() != 0 || this.getCanonicalDuration().getYears() == 0) {
            sb.append(this.getCanonicalDuration().getMonths() + "M");
        }
        return sb.toString();
    }

    @Override
    public AtomicValue convertTo(int requiredType) throws XPathException {
        switch (requiredType) {
            case 11: 
            case 20: 
            case 54: {
                return this;
            }
            case 22: {
                return new StringValue(this.getStringValue());
            }
            case 53: {
                return new DurationValue(TimeUtils.getInstance().newDuration(this.duration.getSign() >= 0, (BigInteger)this.duration.getField(DatatypeConstants.YEARS), (BigInteger)this.duration.getField(DatatypeConstants.MONTHS), null, null, null, null));
            }
            case 55: {
                return new DayTimeDurationValue(DayTimeDurationValue.CANONICAL_ZERO_DURATION);
            }
            case 21: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        throw new XPathException(ErrorCodes.XPTY0004, "cannot cast 'xs:yearMonthDuration(\"" + this.getStringValue() + "\")' to " + Type.getTypeName(requiredType));
    }

    @Override
    protected DurationValue createSameKind(Duration dur) throws XPathException {
        return new YearMonthDurationValue(dur);
    }

    @Override
    public ComputableValue plus(ComputableValue other) throws XPathException {
        try {
            if (other.getType() == 52) {
                throw new IllegalArgumentException();
            }
            return super.plus(other);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException("Operand to plus should be of type xdt:yearMonthDuration, xs:date, or xs:dateTime; got: " + Type.getTypeName(other.getType()));
        }
    }

    @Override
    public ComputableValue mult(ComputableValue other) throws XPathException {
        BigDecimal factor;
        if (other instanceof NumericValue) {
            if (((NumericValue)other).isNaN()) {
                throw new XPathException(ErrorCodes.FOCA0005, "Operand is not a number");
            }
            if (((NumericValue)other).isInfinite()) {
                throw new XPathException(ErrorCodes.FODT0002, "Multiplication by infinity overflow");
            }
        }
        boolean isFactorNegative = (factor = this.numberToBigDecimal(other, "Operand to mult should be of numeric type; got: ")).signum() < 0;
        YearMonthDurationValue product = this.fromDecimalMonths(new BigDecimal(this.monthsValueSigned()).multiply(factor.abs()).setScale(0, isFactorNegative ? 5 : 4));
        if (isFactorNegative) {
            return product.negate();
        }
        return product;
    }

    @Override
    public ComputableValue div(ComputableValue other) throws XPathException {
        BigDecimal divisor;
        if (other.getType() == 54) {
            return new IntegerValue(this.getValue()).div(new IntegerValue(((YearMonthDurationValue)other).getValue()));
        }
        if (other instanceof NumericValue) {
            if (((NumericValue)other).isNaN()) {
                throw new XPathException(ErrorCodes.FOCA0005, "Operand is not a number");
            }
            if (((NumericValue)other).isInfinite()) {
                return new YearMonthDurationValue("P0M");
            }
            if (((NumericValue)other).isZero()) {
                throw new XPathException(ErrorCodes.FODT0002, "Division by zero overflow");
            }
        }
        boolean isDivisorNegative = (divisor = this.numberToBigDecimal(other, "Can not divide xdt:yearMonthDuration by '" + Type.getTypeName(other.getType()) + "'")).signum() < 0;
        YearMonthDurationValue quotient = this.fromDecimalMonths(new BigDecimal(this.monthsValueSigned()).divide(divisor.abs(), 0, isDivisorNegative ? 5 : 4));
        if (isDivisorNegative) {
            return quotient.negate();
        }
        return new YearMonthDurationValue(quotient.getCanonicalDuration());
    }

    private YearMonthDurationValue fromDecimalMonths(BigDecimal x) throws XPathException {
        return new YearMonthDurationValue(TimeUtils.getInstance().newDurationYearMonth(x.signum() >= 0, null, x.toBigInteger()));
    }

    @Override
    public boolean effectiveBooleanValue() throws XPathException {
        throw new XPathException(ErrorCodes.FORG0006, "value of type " + Type.getTypeName(this.getType()) + " has no boolean value.");
    }
}

