/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.xqdoc;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.xqdoc.parser.XQDocLexer;
import org.exist.xquery.xqdoc.parser.XQDocParser;

public class XQDocHelper {
    private StringBuilder description = new StringBuilder();
    private Map<String, String> parameters = new HashMap<String, String>();
    private String returnValue = null;
    private Map<String, String> meta = new HashMap<String, String>();

    public static void parse(FunctionSignature signature) {
        String desc = signature.getDescription();
        if (desc == null || !desc.startsWith("(:")) {
            return;
        }
        XQDocHelper helper = XQDocHelper.parseComment(desc);
        if (helper == null) {
            return;
        }
        helper.enhance(signature);
    }

    public static void parse(ExternalModule module) {
        String desc = module.getDescription();
        if (desc == null || !desc.startsWith("(:")) {
            return;
        }
        XQDocHelper helper = XQDocHelper.parseComment(desc);
        if (helper == null) {
            return;
        }
        helper.enhance(module);
    }

    private static XQDocHelper parseComment(String desc) {
        XQDocLexer lexer = new XQDocLexer(new StringReader(desc));
        XQDocParser parser = new XQDocParser(lexer);
        try {
            XQDocHelper helper = new XQDocHelper();
            parser.xqdocComment(helper);
            return helper;
        }
        catch (RecognitionException recognitionException) {
        }
        catch (TokenStreamException tokenStreamException) {
            // empty catch block
        }
        return null;
    }

    public void addDescription(CharSequence part) {
        this.description.append(part.toString().trim());
    }

    public void setParameter(String comment) {
        String[] components = comment.trim().split("\\s+", 2);
        if (components != null && components.length == 2) {
            String var = components[0];
            if (var.length() > 0 && var.charAt(0) == '$') {
                var = var.substring(1);
            }
            this.parameters.put(var, components[1].trim());
        }
    }

    public void setTag(String tag, String content) {
        if ("@param".equals(tag)) {
            this.setParameter(content.trim());
        } else if ("@return".equals(tag)) {
            this.returnValue = content.trim();
        } else {
            this.meta.put(tag, content);
        }
    }

    protected void enhance(FunctionSignature signature) {
        signature.setDescription(this.description.toString().trim());
        if (this.returnValue != null) {
            SequenceType returnType = signature.getReturnType();
            FunctionReturnSequenceType newType = new FunctionReturnSequenceType(returnType.getPrimaryType(), returnType.getCardinality(), this.returnValue);
            signature.setReturnType(newType);
        }
        SequenceType[] args = signature.getArgumentTypes();
        for (SequenceType type : args) {
            FunctionParameterSequenceType argType;
            String desc;
            if (!(type instanceof FunctionParameterSequenceType) || (desc = this.parameters.get((argType = (FunctionParameterSequenceType)type).getAttributeName())) == null) continue;
            argType.setDescription(desc);
        }
        for (Map.Entry entry : this.meta.entrySet()) {
            String key = (String)entry.getKey();
            if (key.length() > 1 && key.charAt(0) == '@') {
                key = key.substring(1);
            }
            signature.addMetadata(key, (String)entry.getValue());
        }
    }

    protected void enhance(ExternalModule module) {
        module.setDescription(this.description.toString().trim());
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            String key = entry.getKey();
            if (key.length() > 1 && key.charAt(0) == '@') {
                key = key.substring(1);
            }
            module.addMetadata(key, entry.getValue());
        }
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.description.toString().trim()).append("\n\n");
        for (Map.Entry<String, String> entry : this.meta.entrySet()) {
            out.append(String.format("%20s\t%s\n", entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            out.append(String.format("%20s\t%s\n", entry.getKey(), entry.getValue()));
        }
        return out.toString();
    }
}

