/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.xmldb.XmldbURI;
import org.exist.xslt.EXistURIResolver;
import org.exist.xslt.Stylesheet;
import org.exist.xslt.TransformerFactoryAllocator;
import org.exist.xslt.XSLTErrorsListener;
import org.xml.sax.SAXException;

@ThreadSafe
public class StylesheetResolverAndCompiler
implements Stylesheet {
    protected static final Logger LOG = LogManager.getLogger(StylesheetResolverAndCompiler.class);
    SAXTransformerFactory factory;
    long lastModified = -1L;
    Templates templates = null;
    String uri;
    String base;
    Properties properties;

    public StylesheetResolverAndCompiler(String uri) {
        this.uri = uri;
        int p = uri.lastIndexOf("/");
        this.base = p != -1 ? uri.substring(0, p) : uri;
    }

    public StylesheetResolverAndCompiler(String uri, Properties properties) {
        this(uri);
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <E extends Exception> Templates templates(DBBroker broker, XSLTErrorsListener<E> errorListener) throws E, TransformerConfigurationException, IOException, PermissionDeniedException, SAXException {
        if (this.uri.startsWith("xmldb:exist://")) {
            String docPath = this.uri.substring("xmldb:exist://".length());
            DocumentImpl doc = null;
            try {
                doc = broker.getXMLResource(XmldbURI.create(docPath), Lock.LockMode.READ_LOCK);
                if (doc == null) {
                    throw new IOException("XSL stylesheet not found: " + docPath);
                }
                if (this.templates != null && doc.getMetadata().getLastModified() <= this.lastModified) return this.templates;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("compiling stylesheet " + doc.getURI());
                }
                this.templates = this.compileTemplates(broker, doc, errorListener);
                this.lastModified = doc.getMetadata().getLastModified();
                return this.templates;
            }
            finally {
                if (doc != null) {
                    doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        URL url = new URL(this.uri);
        URLConnection connection = url.openConnection();
        long modified = connection.getLastModified();
        if (this.templates == null || modified > this.lastModified || modified == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("compiling stylesheet " + url);
            }
            try (InputStream is = connection.getInputStream();){
                this.templates = this.factory(broker.getBrokerPool(), errorListener).newTemplates(new StreamSource(is));
            }
        }
        this.lastModified = modified;
        return this.templates;
    }

    @Override
    public <E extends Exception> TransformerHandler newTransformerHandler(DBBroker broker, XSLTErrorsListener<E> errorListener) throws E, PermissionDeniedException, SAXException, TransformerConfigurationException, IOException {
        TransformerHandler handler = this.cachedFactory(broker.getBrokerPool()).newTransformerHandler(this.templates(broker, errorListener));
        handler.getTransformer().setErrorListener(errorListener);
        return handler;
    }

    private <E extends Exception> Templates compileTemplates(DBBroker broker, DocumentImpl stylesheet, XSLTErrorsListener<E> errorListener) throws E, TransformerConfigurationException, SAXException {
        TemplatesHandler handler = this.factory(broker.getBrokerPool(), errorListener).newTemplatesHandler();
        handler.startDocument();
        Serializer serializer = broker.newSerializer();
        serializer.reset();
        serializer.setSAXHandlers(handler, null);
        serializer.toSAX(stylesheet);
        handler.endDocument();
        Templates t = handler.getTemplates();
        errorListener.checkForErrors();
        return t;
    }

    private SAXTransformerFactory cachedFactory(BrokerPool db) {
        if (this.factory == null) {
            this.factory = TransformerFactoryAllocator.getTransformerFactory(db);
            if (this.properties != null) {
                for (Map.Entry<Object, Object> attribute : this.properties.entrySet()) {
                    this.factory.setAttribute((String)attribute.getKey(), attribute.getValue());
                }
            }
            this.factory.setURIResolver(new EXistURIResolver(db, this.base));
        }
        return this.factory;
    }

    private <E extends Exception> SAXTransformerFactory factory(BrokerPool db, XSLTErrorsListener<E> errorListener) {
        SAXTransformerFactory newFactory = TransformerFactoryAllocator.getTransformerFactory(db);
        if (this.properties != null) {
            for (Map.Entry<Object, Object> attribute : this.properties.entrySet()) {
                newFactory.setAttribute((String)attribute.getKey(), attribute.getValue());
            }
        }
        newFactory.setURIResolver(new EXistURIResolver(db, this.base));
        newFactory.setErrorListener(errorListener);
        return newFactory;
    }
}

