/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xslt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import net.jcip.annotations.ThreadSafe;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.xquery.value.NodeValue;
import org.exist.xslt.EXistURIResolver;
import org.exist.xslt.Stylesheet;
import org.exist.xslt.StylesheetResolverAndCompiler;
import org.exist.xslt.TransformerFactoryAllocator;
import org.exist.xslt.XSLTErrorsListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@ThreadSafe
public class TemplatesFactory {
    private static final ConcurrentMap<String, StylesheetResolverAndCompiler> cache = new ConcurrentHashMap<String, StylesheetResolverAndCompiler>();

    public static Stylesheet stylesheet(String stylesheet, String baseUri, Properties properties, boolean useCache) {
        if (useCache && properties == null) {
            return TemplatesFactory.stylesheet(stylesheet, baseUri);
        }
        String uri = TemplatesFactory.uri(stylesheet, baseUri);
        return new StylesheetResolverAndCompiler(uri, properties);
    }

    private static Stylesheet stylesheet(String stylesheet, String baseUri) {
        String uri = TemplatesFactory.uri(stylesheet, baseUri);
        return cache.computeIfAbsent(uri, StylesheetResolverAndCompiler::new);
    }

    public static Stylesheet stylesheet(String stylesheet, String baseUri, boolean useCache) {
        if (useCache) {
            return TemplatesFactory.stylesheet(stylesheet, baseUri);
        }
        return new StylesheetResolverAndCompiler(TemplatesFactory.uri(stylesheet, baseUri));
    }

    private static String uri(String stylesheet, String baseUri) {
        String uri = stylesheet;
        if (stylesheet.indexOf(58) == -1) {
            Path f = Paths.get(stylesheet, new String[0]).normalize();
            if (Files.isReadable(f)) {
                uri = f.toUri().toASCIIString();
            } else {
                f = Paths.get(baseUri, stylesheet).normalize();
                if (Files.isReadable(f)) {
                    uri = f.toUri().toASCIIString();
                }
            }
        }
        return uri;
    }

    public static <E extends Exception> Stylesheet stylesheet(DBBroker broker, final NodeValue node, String baseUri) throws E, TransformerConfigurationException {
        String uri;
        final SAXTransformerFactory factory = TransformerFactoryAllocator.getTransformerFactory(broker.getBrokerPool());
        String base = baseUri;
        Document doc = node.getOwnerDocument();
        if (doc != null && (uri = doc.getDocumentURI()) != null) {
            base = uri.substring(0, uri.lastIndexOf(47));
        }
        if (base != null) {
            factory.setURIResolver(new EXistURIResolver(broker.getBrokerPool(), base));
        }
        return new Stylesheet(){

            @Override
            public <E extends Exception> Templates templates(DBBroker broker, XSLTErrorsListener<E> errorListener) throws E, TransformerConfigurationException, IOException, PermissionDeniedException, SAXException {
                TemplatesHandler handler = factory.newTemplatesHandler();
                handler.startDocument();
                node.toSAX(broker, handler, null);
                handler.endDocument();
                Templates t = handler.getTemplates();
                errorListener.checkForErrors();
                return t;
            }

            @Override
            public <E extends Exception> TransformerHandler newTransformerHandler(DBBroker broker, XSLTErrorsListener<E> errorListener) throws E, PermissionDeniedException, SAXException, TransformerConfigurationException, IOException {
                TransformerHandler handler = factory.newTransformerHandler(this.templates(broker, errorListener));
                handler.getTransformer().setErrorListener(errorListener);
                return handler;
            }
        };
    }
}

