/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xslt;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class XSLTErrorsListener<E extends Exception>
implements ErrorListener {
    private static final Logger LOG = LogManager.getLogger(XSLTErrorsListener.class);
    private static final int NO_ERROR = 0;
    private static final int WARNING = 1;
    private static final int ERROR = 2;
    private static final int FATAL = 3;
    boolean stopOnError;
    boolean stopOnWarn;
    private int errorCode = 0;
    private Exception exception;

    public XSLTErrorsListener(boolean stopOnError, boolean stopOnWarn) {
        this.stopOnError = stopOnError;
        this.stopOnWarn = stopOnWarn;
    }

    protected abstract void raiseError(String var1, Exception var2) throws E;

    public void checkForErrors() throws E {
        switch (this.errorCode) {
            case 1: {
                if (!this.stopOnWarn) break;
                this.raiseError("XSL transform reported warning: " + this.exception.getMessage(), this.exception);
                break;
            }
            case 2: {
                if (!this.stopOnError) break;
                this.raiseError("XSL transform reported error: " + this.exception.getMessage(), this.exception);
                break;
            }
            case 3: {
                this.raiseError("XSL transform reported error: " + this.exception.getMessage(), this.exception);
            }
        }
    }

    @Override
    public void warning(TransformerException except) throws TransformerException {
        LOG.warn("XSL transform reports warning: " + except.getMessage(), (Throwable)except);
        this.errorCode = 1;
        this.exception = except;
        if (this.stopOnWarn) {
            throw except;
        }
    }

    @Override
    public void error(TransformerException except) throws TransformerException {
        LOG.warn("XSL transform reports recoverable error: " + except.getMessage(), (Throwable)except);
        this.errorCode = 2;
        this.exception = except;
        if (this.stopOnError) {
            throw except;
        }
    }

    @Override
    public void fatalError(TransformerException except) throws TransformerException {
        LOG.warn("XSL transform reports fatal error: " + except.getMessage(), (Throwable)except);
        this.errorCode = 3;
        this.exception = except;
        throw except;
    }
}

