/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Attr;

public class Remove
extends Modification {
    public Remove(DBBroker broker, DocumentSet docs, String selectStmt, Map<String, String> namespaces, Map<String, Object> variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException, TriggerException {
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                DocumentImpl doc = node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.broker.getCurrentSubject(), 2)) {
                    throw new PermissionDeniedException("User '" + this.broker.getCurrentSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                }
                NodeImpl parent = node.getNodeType() == 2 ? (NodeImpl)((Object)((Attr)((Object)node)).getOwnerElement()) : (NodeImpl)node.getParentNode();
                if (parent == null || parent.getNodeType() != 1) {
                    throw new EXistException("you cannot remove the document element. Use update instead");
                }
                parent.removeChild(transaction, node);
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
            long l = ql.length;
            return l;
        }
        finally {
            this.unlockDocuments(transaction);
        }
    }

    @Override
    public String getName() {
        return "remove";
    }
}

