/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.QName;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.NodeImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.NodeList;

public class Rename
extends Modification {
    public Rename(DBBroker broker, DocumentSet docs, String selectStmt, Map<String, String> namespaces, Map<String, Object> variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException, TriggerException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        int modificationCount = 0;
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            String newName = children.item(0).getTextContent();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                DocumentImpl doc = node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.broker.getCurrentSubject(), 2)) {
                    throw new PermissionDeniedException("User '" + this.broker.getCurrentSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                }
                switch (node.getNodeType()) {
                    case 1: {
                        ElementImpl newElem = new ElementImpl((ElementImpl)node);
                        newElem.setNodeName(new QName(newName, "", null));
                        NodeImpl parent = (NodeImpl)node.getParentNode();
                        parent.updateChild(transaction, node, newElem);
                        ++modificationCount;
                        break;
                    }
                    case 2: {
                        AttrImpl newAttr = new AttrImpl((AttrImpl)node);
                        newAttr.setNodeName(new QName(newName, "", null));
                        NodeImpl parent = (NodeImpl)((Object)((AttrImpl)node).getOwnerElement());
                        parent.updateChild(transaction, node, newAttr);
                        ++modificationCount;
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
        }
        finally {
            this.unlockDocuments(transaction);
        }
        return modificationCount;
    }

    @Override
    public String getName() {
        return "rename";
    }
}

