/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xupdate;

import java.util.Map;
import org.exist.EXistException;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.AttrImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.DocumentSet;
import org.exist.dom.persistent.ElementImpl;
import org.exist.dom.persistent.StoredNode;
import org.exist.dom.persistent.TextImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.NotificationService;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xquery.XPathException;
import org.exist.xupdate.Modification;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Replace
extends Modification {
    public Replace(DBBroker broker, DocumentSet docs, String selectStmt, Map<String, String> namespaces, Map<String, Object> variables) {
        super(broker, docs, selectStmt, namespaces, variables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long process(Txn transaction) throws PermissionDeniedException, LockException, EXistException, XPathException, TriggerException {
        NodeList children = this.content;
        if (children.getLength() == 0) {
            return 0L;
        }
        if (children.getLength() > 1) {
            throw new EXistException("xupdate:replace requires exactly one content node");
        }
        LOG.debug("processing replace ...");
        int modifications = children.getLength();
        try {
            StoredNode[] ql = this.selectAndLock(transaction);
            NotificationService notifier = this.broker.getBrokerPool().getNotificationService();
            for (int i = 0; i < ql.length; ++i) {
                StoredNode node = ql[i];
                if (node == null) {
                    LOG.warn("select " + this.selectStmt + " returned empty node set");
                    continue;
                }
                DocumentImpl doc = node.getOwnerDocument();
                if (!doc.getPermissions().validate(this.broker.getCurrentSubject(), 2)) {
                    throw new PermissionDeniedException("User '" + this.broker.getCurrentSubject().getName() + "' does not have permission to write to the document '" + doc.getDocumentURI() + "'!");
                }
                ElementImpl parent = (ElementImpl)node.getParentStoredNode();
                if (parent == null) {
                    throw new EXistException("The root element of a document can not be replaced with 'xu:replace'. Please consider removing the document or use 'xu:update' to just replace the children of the root.");
                }
                switch (node.getNodeType()) {
                    case 1: {
                        if (modifications == 0) {
                            modifications = 1;
                        }
                        Node temp = children.item(0);
                        parent.replaceChild(transaction, temp, node);
                        break;
                    }
                    case 3: {
                        Node temp = children.item(0);
                        TextImpl text = new TextImpl(temp.getNodeValue());
                        modifications = 1;
                        text.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, text);
                        break;
                    }
                    case 2: {
                        AttrImpl attr = (AttrImpl)node;
                        Node temp = children.item(0);
                        AttrImpl attribute = new AttrImpl(attr.getQName(), temp.getNodeValue(), this.broker.getBrokerPool().getSymbols());
                        attribute.setOwnerDocument(doc);
                        parent.updateChild(transaction, node, attribute);
                        break;
                    }
                    default: {
                        throw new EXistException("unsupported node-type");
                    }
                }
                doc.getMetadata().setLastModified(System.currentTimeMillis());
                this.modifiedDocuments.add(doc);
                this.broker.storeXMLResource(transaction, doc);
                notifier.notifyUpdate(doc, 1);
            }
            this.checkFragmentation(transaction, this.modifiedDocuments);
        }
        finally {
            this.unlockDocuments(transaction);
        }
        return modifications;
    }

    @Override
    public String getName() {
        return "replace";
    }
}

