/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class Either<L, R> {
    private final boolean isLeft;

    Either(boolean isLeft) {
        this.isLeft = isLeft;
    }

    public final boolean isLeft() {
        return this.isLeft;
    }

    public final boolean isRight() {
        return !this.isLeft;
    }

    public final LeftProjection<L, R> left() {
        return new LeftProjection(this);
    }

    public final RightProjection<L, R> right() {
        return new RightProjection(this);
    }

    public final <T> Either<L, T> map(Function<R, T> f) {
        if (this.isLeft()) {
            return (Left)this;
        }
        return Either.Right(f.apply(((Right)this).value));
    }

    public final <LL extends L, T> Either<LL, T> flatMap(Function<R, Either<LL, T>> f) {
        if (this.isLeft) {
            return (Left)this;
        }
        return f.apply(((Right)this).value);
    }

    public final <T> Either<T, R> leftMap(Function<L, T> f) {
        if (this.isLeft) {
            return Either.Left(f.apply(((Left)this).value));
        }
        return (Right)this;
    }

    public final <T> T fold(Function<L, T> lf, Function<R, T> rf) {
        if (this.isLeft) {
            return lf.apply(((Left)this).value);
        }
        return rf.apply(((Right)this).value);
    }

    public final R getOrElse(R defaultValue) {
        if (this.isLeft()) {
            return defaultValue;
        }
        return ((Right)this).value;
    }

    public final R getOrElse(Supplier<R> lazyDefault) {
        if (this.isLeft()) {
            return lazyDefault.get();
        }
        return ((Right)this).value;
    }

    public final Either<L, R> orElse(Either<L, R> defaultValue) {
        if (this.isLeft()) {
            return defaultValue;
        }
        return this;
    }

    public final Either<L, R> orElse(Supplier<Either<L, R>> lazyDefault) {
        if (this.isLeft()) {
            return lazyDefault.get();
        }
        return this;
    }

    public final <RR extends R> RR valueOr(Function<L, RR> lf) {
        if (this.isLeft()) {
            return lf.apply(((Left)this).value);
        }
        return (RR)((Right)this).value;
    }

    public final <LT extends Throwable> R valueOrThrow(Function<L, LT> lf) throws LT {
        if (this.isLeft()) {
            throw (Throwable)lf.apply(((Left)this).value);
        }
        return ((Right)this).value;
    }

    public Either<R, L> swap() {
        return this.fold(Either::Right, Either::Left);
    }

    public Optional<R> toOptional() {
        return this.fold(l -> Optional.empty(), Optional::of);
    }

    public static <L extends Throwable, R> R valueOrThrow(Either<L, R> either) throws L {
        if (either.isLeft()) {
            throw (Throwable)((Left)either).value;
        }
        return ((Right)either).value;
    }

    public static <L, R> Either<L, R> Left(L value) {
        return new Left(value);
    }

    public static <L, R> Either<L, R> Right(R value) {
        return new Right(value);
    }

    public final class RightProjection<L, R> {
        final Either<L, R> e;

        private RightProjection(Either<L, R> e) {
            this.e = e;
        }

        public final R get() {
            if (this.e.isRight()) {
                return ((Right)this.e).value;
            }
            throw new NoSuchElementException("Either#Right value on Left");
        }
    }

    public final class LeftProjection<L, R> {
        final Either<L, R> e;

        private LeftProjection(Either<L, R> e) {
            this.e = e;
        }

        public final L get() {
            if (this.e.isLeft()) {
                return ((Left)this.e).value;
            }
            throw new NoSuchElementException("Either#Left value on Right");
        }
    }

    public static class Right<L, R>
    extends Either<L, R> {
        final R value;

        private Right(R value) {
            super(false);
            this.value = value;
        }

        public String toString() {
            return "Right(" + this.value + ')';
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Right) {
                return this.value.equals(((Right)other).value);
            }
            return this.value.equals(other);
        }
    }

    public static class Left<L, R>
    extends Either<L, R> {
        final L value;

        private Left(L value) {
            super(true);
            this.value = value;
        }

        public String toString() {
            return "Left(" + this.value + ')';
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other instanceof Left) {
                return this.value.equals(((Left)other).value);
            }
            return this.value.equals(other);
        }
    }
}

