/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.fsm;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import com.evolvedbinary.j8fu.fsm.FSM;
import java.util.concurrent.atomic.AtomicReference;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AtomicFSM<State extends Enum<State>, Event extends Enum<Event>>
extends FSM<State, Event> {
    private final AtomicReference<State> currentState;

    public AtomicFSM(State initialState, EventProcessor<State, Event> eventProcessor) {
        super(eventProcessor);
        this.currentState = new AtomicReference<State>(initialState);
    }

    @Override
    public State getCurrentState() {
        return (State)((Enum)this.currentState.get());
    }

    @Override
    public State process(Event event) throws IllegalStateException {
        State state = this.getCurrentState();
        Either<IllegalStateException, State> result = this.eventProcessor.apply(state, event);
        if (result.isLeft()) {
            throw result.left().get();
        }
        if (this.currentState.compareAndSet(state, result.right().get())) {
            return (State)((Enum)result.right().get());
        }
        return this.process(event);
    }
}

