/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.fsm;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.fsm.EventProcessor;
import java.util.EnumMap;

public class TransitionTable<State extends Enum<State>, Event extends Enum<Event>>
implements EventProcessor<State, Event> {
    private final EnumMap<State, EnumMap<Event, State>> transition;
    private final boolean ignoreUnknownEvents;

    public TransitionTable(boolean ignoreUnknownEvents, EnumMap<State, EnumMap<Event, State>> transitionTable) {
        this.ignoreUnknownEvents = ignoreUnknownEvents;
        this.transition = transitionTable;
    }

    public TransitionTable(EnumMap<State, EnumMap<Event, State>> transitionTable) {
        this(false, transitionTable);
    }

    @Override
    public Either<IllegalStateException, State> apply(State currentState, Event event) {
        EnumMap<Event, State> transitions = this.transition.get(currentState);
        if (!this.ignoreUnknownEvents && transitions == null) {
            throw new IllegalStateException("No known transitions from current state '" + ((Enum)currentState).name() + "'");
        }
        Enum newState = (Enum)transitions.get(event);
        if (newState == null) {
            if (!this.ignoreUnknownEvents) {
                throw new IllegalStateException("No known transition from current state '" + ((Enum)currentState).name() + "' for event '" + ((Enum)event).name() + "'");
            }
            return Either.Right(currentState);
        }
        return Either.Right(newState);
    }

    public static <State extends Enum<State>, Event extends Enum<Event>> TransitionTableBuilder<State, Event> transitionTable(Class<State> stateType, Class<Event> eventType) {
        return new TransitionTableBuilder(stateType, eventType);
    }

    public static class TransitionTableBuilder<State extends Enum<State>, Event extends Enum<Event>> {
        private final EnumMap<State, EnumMap<Event, State>> transitionTable;
        private final Class<Event> eventType;

        private TransitionTableBuilder(Class<State> stateType, Class<Event> eventType) {
            this.transitionTable = new EnumMap(stateType);
            this.eventType = eventType;
        }

        public EventBuilder when(State currentState) {
            return new EventBuilder(this, (Enum)currentState);
        }

        public static class TransitionTableBuilderS {
            private final State prevState;
            final /* synthetic */ TransitionTableBuilder this$0;

            private TransitionTableBuilderS(State prevState) {
                this.this$0 = this$0;
                this.prevState = prevState;
            }

            public NewStateBuilder on(Event event) {
                return new NewStateBuilder(this.this$0, (Enum)this.prevState, (Enum)event);
            }

            public EventBuilder when(State currentState) {
                return new EventBuilder(this.this$0, (Enum)currentState);
            }

            public TransitionTable<State, Event> build(boolean ignoreUnknownEvents) {
                return new TransitionTable(ignoreUnknownEvents, this.this$0.transitionTable);
            }

            public TransitionTable<State, Event> build() {
                return new TransitionTable(this.this$0.transitionTable);
            }
        }

        public static class NewStateBuilder {
            private final State currentState;
            private final Event event;
            final /* synthetic */ TransitionTableBuilder this$0;

            private NewStateBuilder(State currentState, Event event) {
                this.this$0 = this$0;
                this.currentState = currentState;
                this.event = event;
            }

            public TransitionTableBuilderS switchTo(State newState) {
                EnumMap transition = (EnumMap)this.this$0.transitionTable.get(this.currentState);
                if (transition == null) {
                    transition = new EnumMap(this.this$0.eventType);
                }
                transition.put(this.event, newState);
                this.this$0.transitionTable.put(this.currentState, transition);
                return new TransitionTableBuilderS(this.this$0, (Enum)newState);
            }
        }

        public static class EventBuilder {
            private final State currentState;
            final /* synthetic */ TransitionTableBuilder this$0;

            private EventBuilder(State currentState) {
                this.this$0 = this$0;
                this.currentState = currentState;
            }

            public NewStateBuilder on(Event event) {
                return new NewStateBuilder(this.this$0, (Enum)this.currentState, (Enum)event);
            }
        }
    }
}

