/*
 * Decompiled with CFR 0.152.
 */
package com.evolvedbinary.j8fu.managed;

import com.evolvedbinary.j8fu.Either;
import com.evolvedbinary.j8fu.function.BiConsumerE;
import com.evolvedbinary.j8fu.function.FunctionE;
import java.util.Arrays;
import java.util.List;

public class ManagedResourceEither<T, AR, AE extends Exception, RE extends Exception> {
    private final T subject;
    private final FunctionE<T, AR, AE> acquireFn;
    private final BiConsumerE<T, AR, RE> releaseFn;

    private ManagedResourceEither(T subject, FunctionE<T, AR, AE> acquireFn, BiConsumerE<T, AR, RE> releaseFn) {
        this.subject = subject;
        this.acquireFn = acquireFn;
        this.releaseFn = releaseFn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U, UE extends Exception> Either<List<Exception>, U> map(FunctionE<AR, U, UE> mapper) {
        Exception acquireException = null;
        Exception mapperException = null;
        Object acquireResult = null;
        Object mapResult = null;
        try {
            try {
                acquireResult = this.acquireFn.apply(this.subject);
                try {
                    mapResult = mapper.apply(acquireResult);
                }
                catch (Exception e) {
                    mapperException = e;
                }
            }
            catch (Exception e) {
                acquireException = e;
            }
        }
        catch (Throwable throwable) {
            try {
                this.releaseFn.accept(this.subject, acquireResult);
                if (acquireException != null) {
                    return Either.Left(Arrays.asList(acquireException));
                }
                if (mapperException != null) {
                    return Either.Left(Arrays.asList(mapperException));
                }
                return Either.Right(mapResult);
            }
            catch (Exception releaseException) {
                if (acquireException != null) {
                    return Either.Left(Arrays.asList(acquireException, releaseException));
                }
                if (mapperException != null) {
                    return Either.Left(Arrays.asList(mapperException, releaseException));
                }
                return Either.Left(Arrays.asList(releaseException));
            }
        }
        try {
            this.releaseFn.accept(this.subject, acquireResult);
            if (acquireException != null) {
                return Either.Left(Arrays.asList(acquireException));
            }
            if (mapperException != null) {
                return Either.Left(Arrays.asList(mapperException));
            }
            return Either.Right(mapResult);
        }
        catch (Exception releaseException) {
            if (acquireException != null) {
                return Either.Left(Arrays.asList(acquireException, releaseException));
            }
            if (mapperException != null) {
                return Either.Left(Arrays.asList(mapperException, releaseException));
            }
            return Either.Left(Arrays.asList(releaseException));
        }
    }

    public static <T, AR, AE extends Exception, RE extends Exception> ManagedResourceEither<T, AR, AE, RE> managedEither(T subject, FunctionE<T, AR, AE> acquireFn, BiConsumerE<T, AR, RE> releaseFn) {
        return new ManagedResourceEither<T, AR, AE, RE>(subject, acquireFn, releaseFn);
    }
}

