/*
 * Decompiled with CFR 0.152.
 */
package org.exist.contentextraction;

import java.io.IOException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.exist.contentextraction.AbortAfterMetadataContentHandler;
import org.exist.contentextraction.AbortedAfterMetadataException;
import org.exist.contentextraction.ContentExtractionException;
import org.exist.util.serializer.Receiver;
import org.exist.util.serializer.SAXToReceiver;
import org.exist.xquery.value.BinaryValue;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentExtraction {
    final Parser parser = new AutoDetectParser();
    final ParseContext parseContext = new ParseContext();

    public ContentExtraction() {
        this.parseContext.set(Parser.class, (Object)this.parser);
    }

    public void extractContentAndMetadata(BinaryValue binaryValue, ContentHandler contentHandler) throws IOException, SAXException, ContentExtractionException {
        Metadata metadata = new Metadata();
        try {
            this.parser.parse(binaryValue.getInputStream(), contentHandler, metadata, this.parseContext);
        }
        catch (TikaException e) {
            throw new ContentExtractionException("Problem with content extraction library: " + e.getMessage(), e);
        }
    }

    public void extractContentAndMetadata(BinaryValue binaryValue, Receiver receiver) throws IOException, SAXException, ContentExtractionException {
        this.extractContentAndMetadata(binaryValue, (ContentHandler)new SAXToReceiver(receiver, false));
    }

    public void extractMetadata(BinaryValue binaryValue, ContentHandler contentHandler) throws IOException, SAXException, ContentExtractionException {
        Metadata metadata = new Metadata();
        try {
            this.parser.parse(binaryValue.getInputStream(), (ContentHandler)new AbortAfterMetadataContentHandler(contentHandler), metadata, this.parseContext);
        }
        catch (TikaException e) {
            throw new ContentExtractionException("Problem with content extraction library: " + e.getMessage(), e);
        }
        catch (AbortedAfterMetadataException abortedAfterMetadataException) {
            // empty catch block
        }
    }
}

