/*
 * Decompiled with CFR 0.152.
 */
package org.exist.contentextraction;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.INodeHandle;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.storage.NodePath;
import org.exist.util.serializer.AttrList;
import org.exist.util.serializer.Receiver;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReference;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.ValueSequence;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class ContentReceiver
implements Receiver {
    private static final Logger LOG = LogManager.getLogger(ContentReceiver.class);
    private final ValueSequence result = new ValueSequence();
    private final FunctionReference ref;
    private final NodePath currentElementPath = new NodePath();
    private final NodePath[] paths;
    private DocumentBuilderReceiver docBuilderReceiver = null;
    private NodePath startElementPath = null;
    private Sequence userData = null;
    private Sequence prevReturnData = Sequence.EMPTY_SEQUENCE;
    private final XQueryContext context;
    private boolean sendDataToCB = false;

    public ContentReceiver(XQueryContext context, NodePath[] paths, FunctionReference ref, Sequence userData) {
        this.context = context;
        this.paths = paths;
        this.ref = ref;
        this.userData = userData;
    }

    public Sequence getResult() {
        return this.result;
    }

    private boolean matches(NodePath path) {
        for (NodePath p : this.paths) {
            if (!p.match(path)) continue;
            return true;
        }
        return false;
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(QName qname, AttrList attribs) throws SAXException {
        this.currentElementPath.addComponent(qname);
        if (this.matches(this.currentElementPath) && !this.sendDataToCB) {
            this.startElementPath = new NodePath(this.currentElementPath);
            this.context.pushDocumentContext();
            MemTreeBuilder memBuilder = this.context.getDocumentBuilder();
            this.docBuilderReceiver = new DocumentBuilderReceiver(memBuilder);
            this.sendDataToCB = true;
        }
        if (this.sendDataToCB) {
            this.docBuilderReceiver.startElement(qname, attribs);
        }
    }

    public void endElement(QName qname) throws SAXException {
        if (this.sendDataToCB) {
            this.docBuilderReceiver.endElement(qname);
        }
        if (this.sendDataToCB && this.currentElementPath.match(this.startElementPath)) {
            this.sendDataToCallback();
            this.context.popDocumentContext();
            this.sendDataToCB = false;
            this.docBuilderReceiver = null;
        }
        this.currentElementPath.removeLastComponent();
    }

    public void characters(CharSequence seq) throws SAXException {
        if (this.sendDataToCB) {
            this.docBuilderReceiver.characters(seq);
        }
    }

    public void attribute(QName qname, String value) throws SAXException {
        if (this.sendDataToCB) {
            this.docBuilderReceiver.attribute(qname, value);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void cdataSection(char[] ch, int start, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void documentType(String name, String publicId, String systemId) throws SAXException {
    }

    public void highlightText(CharSequence seq) throws SAXException {
    }

    public void setCurrentNode(INodeHandle node) {
    }

    public Document getDocument() {
        return null;
    }

    private void sendDataToCallback() {
        Document doc = this.docBuilderReceiver.getDocument();
        NodeImpl root = (NodeImpl)doc.getDocumentElement();
        Sequence[] params = new Sequence[]{root, this.userData, this.prevReturnData};
        try {
            Sequence ret;
            this.prevReturnData = ret = this.ref.evalFunction(null, null, params);
            this.result.addAll(ret);
        }
        catch (XPathException e) {
            LOG.warn(e.getMessage(), (Throwable)e);
        }
    }
}

