//>>built
require({cache:{
'dojo/NodeList-fx':function(){
define("dojo/NodeList-fx", ["dojo/_base/NodeList", "./_base/lang", "./_base/connect", "./_base/fx", "./fx"], 
  function(NodeList, lang, connectLib, baseFx, coreFx) {
	// module:
	//		dojo/NodeList-fx
	// summary:
	//		TODOC

/*=====
dojo["NodeList-fx"] = {
	// summary: Adds dojo.fx animation support to dojo.query() by extending the NodeList class
	//		with additional FX functions.  NodeList is the array-like object used to hold query results.
};

// doc alias helpers:
NodeList = dojo.NodeList;
=====*/

lang.extend(NodeList, {
	_anim: function(obj, method, args){
		args = args||{};
		var a = coreFx.combine(
			this.map(function(item){
				var tmpArgs = { node: item };
				lang.mixin(tmpArgs, args);
				return obj[method](tmpArgs);
			})
		);
		return args.auto ? a.play() && this : a; // dojo.Animation|dojo.NodeList
	},

	wipeIn: function(args){
		// summary:
		//		wipe in all elements of this NodeList via `dojo.fx.wipeIn`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//		Fade in all tables with class "blah":
		//		|	dojo.query("table.blah").wipeIn().play();
		//
		// example:
		//		Utilizing `auto` to get the NodeList back:
		//		|	dojo.query(".titles").wipeIn({ auto:true }).onclick(someFunction);
		//
		return this._anim(coreFx, "wipeIn", args); // dojo.Animation|dojo.NodeList
	},

	wipeOut: function(args){
		// summary:
		//		wipe out all elements of this NodeList via `dojo.fx.wipeOut`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//		Wipe out all tables with class "blah":
		//		|	dojo.query("table.blah").wipeOut().play();
		return this._anim(coreFx, "wipeOut", args); // dojo.Animation|dojo.NodeList
	},

	slideTo: function(args){
		// summary:
		//		slide all elements of the node list to the specified place via `dojo.fx.slideTo`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//		|	Move all tables with class "blah" to 300/300:
		//		|	dojo.query("table.blah").slideTo({
		//		|		left: 40,
		//		|		top: 50
		//		|	}).play();
		return this._anim(coreFx, "slideTo", args); // dojo.Animation|dojo.NodeList
	},


	fadeIn: function(args){
		// summary:
		//		fade in all elements of this NodeList via `dojo.fadeIn`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//		Fade in all tables with class "blah":
		//		|	dojo.query("table.blah").fadeIn().play();
		return this._anim(baseFx, "fadeIn", args); // dojo.Animation|dojo.NodeList
	},

	fadeOut: function(args){
		// summary:
		//		fade out all elements of this NodeList via `dojo.fadeOut`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//		Fade out all elements with class "zork":
		//		|	dojo.query(".zork").fadeOut().play();
		// example:
		//		Fade them on a delay and do something at the end:
		//		|	var fo = dojo.query(".zork").fadeOut();
		//		|	dojo.connect(fo, "onEnd", function(){ /*...*/ });
		//		|	fo.play();
		// example:
		//		Using `auto`:
		//		|	dojo.query("li").fadeOut({ auto:true }).filter(filterFn).forEach(doit);
		//
		return this._anim(baseFx, "fadeOut", args); // dojo.Animation|dojo.NodeList
	},

	animateProperty: function(args){
		// summary:
		//		Animate all elements of this NodeList across the properties specified.
		//		syntax identical to `dojo.animateProperty`
		//
		// args: Object?
		//		Additional dojo.Animation arguments to mix into this set with the addition of
		//		an `auto` parameter.
		//
		// returns: dojo.Animation|dojo.NodeList
		//		A special args member `auto` can be passed to automatically play the animation.
		//		If args.auto is present, the original dojo.NodeList will be returned for further
		//		chaining. Otherwise the dojo.Animation instance is returned and must be .play()'ed
		//
		// example:
		//	|	dojo.query(".zork").animateProperty({
		//	|		duration: 500,
		//	|		properties: {
		//	|			color:		{ start: "black", end: "white" },
		//	|			left:		{ end: 300 }
		//	|		}
		//	|	}).play();
		//
		//	example:
		//	|	dojo.query(".grue").animateProperty({
		//	|		auto:true,
		//	|		properties: {
		//	|			height:240
		//	|		}
		//	|	}).onclick(handler);
		return this._anim(baseFx, "animateProperty", args); // dojo.Animation|dojo.NodeList
	},

	anim: function( /*Object*/			properties,
					/*Integer?*/		duration,
					/*Function?*/		easing,
					/*Function?*/		onEnd,
					/*Integer?*/		delay){
		// summary:
		//		Animate one or more CSS properties for all nodes in this list.
		//		The returned animation object will already be playing when it
		//		is returned. See the docs for `dojo.anim` for full details.
		// properties: Object
		//		the properties to animate. does NOT support the `auto` parameter like other
		//		NodeList-fx methods.
		// duration: Integer?
		//		Optional. The time to run the animations for
		// easing: Function?
		//		Optional. The easing function to use.
		// onEnd: Function?
		//		A function to be called when the animation ends
		// delay:
		//		how long to delay playing the returned animation
		// example:
		//		Another way to fade out:
		//	|	dojo.query(".thinger").anim({ opacity: 0 });
		// example:
		//		animate all elements with the "thigner" class to a width of 500
		//		pixels over half a second
		//	|	dojo.query(".thinger").anim({ width: 500 }, 700);
		var canim = coreFx.combine(
			this.map(function(item){
				return baseFx.animateProperty({
					node: item,
					properties: properties,
					duration: duration||350,
					easing: easing
				});
			})
		);
		if(onEnd){
			connectLib.connect(canim, "onEnd", onEnd);
		}
		return canim.play(delay||0); // dojo.Animation
	}
});

return NodeList;
});

},
'bf/common/AlertToolTip':function(){
define("bf/common/AlertToolTip", ["dojo/_base/declare","bf/common/Alert","dojo/dom", "dojo/dom-style","dojo/_base/connect","dojo/_base/lang","dojo/dom-class","dijit/registry", "dojo/NodeList-fx","dojo/query","dijit/Tooltip","dojo/dom-attr"],
    function(declare, Alert,dom,domStyle,connect,lang,domClass,registry,nodeListFx,query,Tooltip,domAttr){
        return declare(Alert, {

        displayDuration:3000,
        hideSpeed:1000,

        _show:function(id, commonChild, action) {
            // console.debug("AlertToolTip._show: [id:" + id , " commonChild: " + commonChild + "]");
            var commonChildNode = dom.byId(id + '-' + commonChild);



            if(commonChild != undefined && commonChild == this.hint) {
                this._render(id, commonChild,"inline");
            }

            else if(commonChildNode != undefined && commonChild == this.alert) {
                // console.debug("AlertToolTip._show: [id:" + id , " commonChildNode: ", commonChildNode ,"]");
                var commonChildId = domAttr.get(commonChildNode,"id");
                var alertTooltip = registry.byId(domAttr.get(commonChildNode,"id"));
                //var alertTooltip = undefined;
                var valueNode = query('.xfValue', dom.byId(id))[0];
                // console.debug("\n\nalert exists:",alertTooltip);
                if(alertTooltip == undefined) {
                    // console.debug("\n\ncreate Tooltip\n\n");


                    // console.debug("commonChildNode.innerHTML: ",commonChildNode);
                    // console.debug("valueNode.id",valueNode.id);

                    alertTooltip = new Tooltip({
                        id:commonChildId,
                        // Delay before showing the Tooltip (in milliseconds)
                        showDelay: 250,
                        // The nodes to attach the Tooltip to
                        // Can be an array of strings or domNodes
                        connectId: [id],

                        label:commonChildNode.innerHTML,

                        defaultPosition:"after"

                    },commonChildNode);

                    /*connectId:[valueNode.id]*/
                    alertTooltip.startup();
                    console.debug("Tooltip: ",alertTooltip);
                    // alertTooltip.open();
                    connect.connect(alertTooltip, "onClick", this, lang.hitch(this, function() {
                        alertTooltip.hideTooltip(valueNode);
                    }));
                }

                // console.debug("AlertToolTip: alertTooltip:",alertTooltip);
                alertTooltip.open(valueNode);

                domStyle.set(alertTooltip.domNode, "opacity", "1");
                domStyle.set(alertTooltip.domNode, "cursor", "pointer");
                domClass.add(alertTooltip.domNode, "bfToolTipAlert");
                domClass.add(valueNode, "bfInvalidControl");


            }
/*
            else if (commonChild == "info" && action == "applyChanges") {
                alertTooltip = registry.byId(id + "-alert");
                if(alertTooltip){
                    console.debug("\n\ndestroy tooltip: ",alertTooltip);
                    alertTooltip.destroy();
                    alertTooltip = undefined;

                }
                // setTimeout(lang.hitch(this,function() {this._fadeOutAndHide(id,commonChild)}),this.displayDuration);
            }
*/
        },


        _hide:function(id, commonChild,action) {
            // console.debug("AlertToolTip._hide: [id:" + id , " commonChild: " + commonChild + "]");
            var commonChildNode = dom.byId(id + '-' + commonChild);
            // console.debug("AlertToolTip._hide commonChildNode:",commonChildNode);

            if (commonChildNode != undefined && commonChild == this.alert) {
                var controlValue = query('.xfValue', dom.byId(id))[0];
                var alertDijit = registry.byId(domAttr.get(commonChildNode,"id"));
                // console.debug("AlertToolTip._hide alertDijit: ",alertDijit);
                if (alertDijit != undefined && controlValue != undefined) {
                    // console.debug("AlertToolTip._hide alertDijit not undefiend: ",alertDijit);
                    alertDijit.close(controlValue);
                }
                if(controlValue != undefined && domClass.contains(controlValue,"bfInvalidControl")) {
                    domClass.remove(controlValue,"bfInvalidControl");
                }
            } else if (commonChild != undefined && commonChild == this.hint) {
                this._render(id, commonChild,"none");
            }
            // console.debug("AlertToolTip._hide END");
        },

        _render:function(id, commonChild, show) {
            // console.debug("AlertToolTip._render [id:'",id,"' commonChild:'", commonChild," ' show:'",show, "']");
            var mip = dom.byId(id + "-" + commonChild);
            if (mip != undefined && mip.innerHTML != '') {
                domStyle.set(mip, "display", show);
            } else {
                console.info(id + "-" + commonChild + " is not defined for Control " + id);
            }
        },



        _fadeOutAndHide:function(id,commonChild) {
            var alertTooltip = registry.byId(id+"-MasterToolTip-" +commonChild);
            // No need to check if tooltip exists since this function is only called if (after a check before) it exists
            var valueNode = query('.xfValue', dom.byId(id))[0];
            // console.debug("AlertToolTip._fadeOutAndHide  [id: " + id + " - alertTooltip:" , alertTooltip ,"]");
            var speed = this.hideSpeed;
            nodeListFx.fadeOut({
                node:alertTooltip.domNode,
                duration:speed,
                onEnd:function() {
                    alertTooltip.hide(valueNode);
            }
            }).play();
        }
    });
});

}}});

require(["dojo/i18n"], function(i18n){
i18n._preloadLocalizations("bf/nls/tooltipAlert", []);
});
define("bf/tooltipAlert", [], 1);
