//>>built
define("dojox/gfx/shape",["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/window","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(b,h,f,n,o,i,l,m,p,g){var c=b.shape={},j={},k={};c.register=function(a){var d=a.declaredClass.split(".").pop(),b=d in j?++j[d]:j[d]=0;d+=b;k[d]=a;return d};c.byId=function(a){return k[a]};c.dispose=function(a){delete k[a.getUID()]};f("dojox.gfx.shape.Shape",null,{constructor:function(){this.parentMatrix=
this.parent=this.bbox=this.strokeStyle=this.fillStyle=this.matrix=this.shape=this.rawNode=null;var a=c.register(this);this.getUID=function(){return a}},getNode:function(){return this.rawNode},getShape:function(){return this.shape},getTransform:function(){return this.matrix},getFill:function(){return this.fillStyle},getStroke:function(){return this.strokeStyle},getParent:function(){return this.parent},getBoundingBox:function(){return this.bbox},getTransformedBoundingBox:function(){var a=this.getBoundingBox();
if(!a)return null;var d=this._getRealMatrix();return[g.multiplyPoint(d,a.x,a.y),g.multiplyPoint(d,a.x+a.width,a.y),g.multiplyPoint(d,a.x+a.width,a.y+a.height),g.multiplyPoint(d,a.x,a.y+a.height)]},getEventSource:function(){return this.rawNode},setShape:function(a){this.shape=b.makeParameters(this.shape,a);this.bbox=null;return this},setFill:function(a){if(!a)return this.fillStyle=null,this;var d=null;if(typeof a=="object"&&"type"in a)switch(a.type){case "linear":d=b.makeParameters(b.defaultLinearGradient,
a);break;case "radial":d=b.makeParameters(b.defaultRadialGradient,a);break;case "pattern":d=b.makeParameters(b.defaultPattern,a)}else d=b.normalizeColor(a);this.fillStyle=d;return this},setStroke:function(a){if(!a)return this.strokeStyle=null,this;if(typeof a=="string"||h.isArray(a)||a instanceof p)a={color:a};a=this.strokeStyle=b.makeParameters(b.defaultStroke,a);a.color=b.normalizeColor(a.color);return this},setTransform:function(a){this.matrix=g.clone(a?g.normalize(a):g.identity);return this._applyTransform()},
_applyTransform:function(){return this},moveToFront:function(){var a=this.getParent();a&&(a._moveChildToFront(this),this._moveToFront());return this},moveToBack:function(){var a=this.getParent();a&&(a._moveChildToBack(this),this._moveToBack());return this},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(a){return a?this.setTransform([this.matrix,a]):this},applyLeftTransform:function(a){return a?this.setTransform([a,this.matrix]):this},applyTransform:function(a){return a?
this.setTransform([this.matrix,a]):this},removeShape:function(a){this.parent&&this.parent.remove(this,a);return this},_setParent:function(a,d){this.parent=a;return this._updateParentMatrix(d)},_updateParentMatrix:function(a){this.parentMatrix=a?g.clone(a):null;return this._applyTransform()},_getRealMatrix:function(){for(var a=this.matrix,d=this.parent;d;)d.matrix&&(a=g.multiply(d.matrix,a)),d=d.parent;return a}});c._eventsProcessing={connect:function(a,d,q){return i.connect(this.getEventSource(),
a,c.fixCallback(this,b.fixTarget,d,q))},disconnect:function(a){i.disconnect(a)}};c.fixCallback=function(a,d,b,e){e||(e=b,b=null);if(h.isString(e)){b=b||n.global;if(!b[e])throw['dojox.gfx.shape.fixCallback: scope["',e,'"] is null (scope="',b,'")'].join("");return function(c){return d(c,a)?b[e].apply(b,arguments||[]):void 0}}return!b?function(c){return d(c,a)?e.apply(b,arguments):void 0}:function(c){return d(c,a)?e.apply(b,arguments||[]):void 0}};h.extend(c.Shape,c._eventsProcessing);c.Container={_init:function(){this.children=
[]},openBatch:function(){},closeBatch:function(){},add:function(a){var d=a.getParent();d&&d.remove(a,!0);this.children.push(a);return a._setParent(this,this._getRealMatrix())},remove:function(a,d){for(var b=0;b<this.children.length;++b)if(this.children[b]==a){if(!d)a.parent=null,a.parentMatrix=null;this.children.splice(b,1);break}return this},clear:function(){for(var a,b=0;b<this.children.length;++b)a=this.children[b],a.parent=null,a.parentMatrix=null;this.children=[];return this},_moveChildToFront:function(a){for(var b=
0;b<this.children.length;++b)if(this.children[b]==a){this.children.splice(b,1);this.children.push(a);break}return this},_moveChildToBack:function(a){for(var b=0;b<this.children.length;++b)if(this.children[b]==a){this.children.splice(b,1);this.children.unshift(a);break}return this}};f("dojox.gfx.shape.Surface",null,{constructor:function(){this._parent=this.rawNode=null;this._nodes=[];this._events=[]},destroy:function(){l.forEach(this._nodes,m.destroy);this._nodes=[];l.forEach(this._events,i.disconnect);
this._events=[];this.rawNode=null;if(o("ie"))for(;this._parent.lastChild;)m.destroy(this._parent.lastChild);else this._parent.innerHTML="";this._parent=null},getEventSource:function(){return this.rawNode},_getRealMatrix:function(){return null},isLoaded:!0,onLoad:function(){},whenLoaded:function(a,b){var c=h.hitch(a,b);if(this.isLoaded)c(this);else var e=i.connect(this,"onLoad",function(a){i.disconnect(e);c(a)})}});h.extend(c.Surface,c._eventsProcessing);f("dojox.gfx.Point",null,{});f("dojox.gfx.Rectangle",
null,{});f("dojox.gfx.shape.Rect",c.Shape,{constructor:function(a){this.shape=b.getDefault("Rect");this.rawNode=a},getBoundingBox:function(){return this.shape}});f("dojox.gfx.shape.Ellipse",c.Shape,{constructor:function(a){this.shape=b.getDefault("Ellipse");this.rawNode=a},getBoundingBox:function(){if(!this.bbox){var a=this.shape;this.bbox={x:a.cx-a.rx,y:a.cy-a.ry,width:2*a.rx,height:2*a.ry}}return this.bbox}});f("dojox.gfx.shape.Circle",c.Shape,{constructor:function(a){this.shape=b.getDefault("Circle");
this.rawNode=a},getBoundingBox:function(){if(!this.bbox){var a=this.shape;this.bbox={x:a.cx-a.r,y:a.cy-a.r,width:2*a.r,height:2*a.r}}return this.bbox}});f("dojox.gfx.shape.Line",c.Shape,{constructor:function(a){this.shape=b.getDefault("Line");this.rawNode=a},getBoundingBox:function(){if(!this.bbox){var a=this.shape;this.bbox={x:Math.min(a.x1,a.x2),y:Math.min(a.y1,a.y2),width:Math.abs(a.x2-a.x1),height:Math.abs(a.y2-a.y1)}}return this.bbox}});f("dojox.gfx.shape.Polyline",c.Shape,{constructor:function(a){this.shape=
b.getDefault("Polyline");this.rawNode=a},setShape:function(a,b){a&&a instanceof Array?(this.inherited(arguments,[{points:a}]),b&&this.shape.points.length&&this.shape.points.push(this.shape.points[0])):this.inherited(arguments,[a]);return this},_normalizePoints:function(){var a=this.shape.points,b=a&&a.length;if(b&&typeof a[0]=="number"){for(var c=[],e=0;e<b;e+=2)c.push({x:a[e],y:a[e+1]});this.shape.points=c}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){for(var a=this.shape.points,
b=a.length,c=a[0],e={l:c.x,t:c.y,r:c.x,b:c.y},f=1;f<b;++f){c=a[f];if(e.l>c.x)e.l=c.x;if(e.r<c.x)e.r=c.x;if(e.t>c.y)e.t=c.y;if(e.b<c.y)e.b=c.y}this.bbox={x:e.l,y:e.t,width:e.r-e.l,height:e.b-e.t}}return this.bbox}});f("dojox.gfx.shape.Image",c.Shape,{constructor:function(a){this.shape=b.getDefault("Image");this.rawNode=a},getBoundingBox:function(){return this.shape},setStroke:function(){return this},setFill:function(){return this}});f("dojox.gfx.shape.Text",c.Shape,{constructor:function(a){this.fontStyle=
null;this.shape=b.getDefault("Text");this.rawNode=a},getFont:function(){return this.fontStyle},setFont:function(a){this.fontStyle=typeof a=="string"?b.splitFontString(a):b.makeParameters(b.defaultFont,a);this._setFont();return this}});c.Creator={createShape:function(a){switch(a.type){case b.defaultPath.type:return this.createPath(a);case b.defaultRect.type:return this.createRect(a);case b.defaultCircle.type:return this.createCircle(a);case b.defaultEllipse.type:return this.createEllipse(a);case b.defaultLine.type:return this.createLine(a);
case b.defaultPolyline.type:return this.createPolyline(a);case b.defaultImage.type:return this.createImage(a);case b.defaultText.type:return this.createText(a);case b.defaultTextPath.type:return this.createTextPath(a)}return null},createGroup:function(){return this.createObject(b.Group)},createRect:function(a){return this.createObject(b.Rect,a)},createEllipse:function(a){return this.createObject(b.Ellipse,a)},createCircle:function(a){return this.createObject(b.Circle,a)},createLine:function(a){return this.createObject(b.Line,
a)},createPolyline:function(a){return this.createObject(b.Polyline,a)},createImage:function(a){return this.createObject(b.Image,a)},createText:function(a){return this.createObject(b.Text,a)},createPath:function(a){return this.createObject(b.Path,a)},createTextPath:function(a){return this.createObject(b.TextPath,{}).setText(a)},createObject:function(){return null}};return c});