/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.app;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Query;
import net.xfra.qizxopen.xquery.SyntaxException;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.dt.QNameValue;
import net.xfra.qizxopen.xquery.fn.JavaFunction;

public class NonReg
extends XQueryProcessor {
    String dataPath = ".";
    XMLSerializer nodeDisplay;
    boolean display = true;
    boolean exprDump = false;
    boolean verbose = false;
    boolean displayDiff = true;
    Input currentInput;
    String curQuery = "";
    String currentTestName = null;
    int queryLine = -1;
    String queryFile;
    boolean firstDiag;
    boolean wrappedDisplay = true;
    boolean traceExceptions = false;
    Vector refData = new Vector();
    StringWriter stringOut = new StringWriter(200);
    PrintWriter output = new PrintWriter(this.stringOut);
    Log log = new Log(this.output);
    static final String INCLUDE_DIRECTIVE = "#include ";
    static final String DOCINPUT_DIRECTIVE = "#docinput ";
    static final String COLLINPUT_DIRECTIVE = "#collinput ";
    static final String DEFVAR_DIRECTIVE = "#defvar ";
    static final String OPTION_DIRECTIVE = "#option ";
    static final String TESTNAME_DIRECTIVE = "#test ";
    static final String OUTPUT_MARK = "=>";
    static final String EOOUTPUT_MARK = "##";
    static final String COMMENT_MARK = "//";

    public static void usage() {
        System.err.println("usage: NonReg <options> <testfile>... ");
        System.err.println("options:");
        System.err.println("  -v           verbose mode");
        System.err.println("  -q           quiet mode");
        System.err.println("  -e           dump query");
        System.err.println("  -diff        no diff: show actual output");
        System.err.println("  -jt          trace Java bindings");
        System.err.println("  -tex         trace exceptions");
    }

    public static void main(String[] stringArray) {
        try {
            NonReg nonReg = new NonReg(".");
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string.equals("-path")) {
                    if (++n >= stringArray.length) {
                        NonReg.usage();
                    }
                    nonReg = new NonReg(stringArray[n]);
                } else if (string.equals("-v")) {
                    nonReg.verbose = true;
                } else if (string.equals("-q")) {
                    nonReg.verbose = false;
                } else if (string.equals("-i")) {
                    nonReg.nodeDisplay.setIndent(-1);
                } else if (string.equals("-diff")) {
                    nonReg.displayDiff = false;
                } else if (string.equals("-e")) {
                    nonReg.exprDump = true;
                } else if (string.equals("-jt")) {
                    JavaFunction.trace = true;
                } else if (string.equals("-tex")) {
                    nonReg.traceExceptions = true;
                } else {
                    nonReg.execFile(string);
                    System.err.println(string + " done");
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("ERROR: " + exception);
        }
    }

    public NonReg(String string) throws IOException {
        super(string, string);
        this.nodeDisplay = new XMLSerializer();
        this.nodeDisplay.setIndent(4);
        this.nodeDisplay.setDepth(-1);
        this.setDefaultOutput(this.output);
        this.nodeDisplay.setOutput(this.output);
        this.dataPath = string;
    }

    public void execFile(String string) throws IOException, XQueryException {
        String string2;
        this.resetDeclarations();
        this.pushInput(string);
        while ((string2 = this.readLine()) != null) {
            String[] stringArray;
            if (string2.length() == 0 || string2.startsWith(COMMENT_MARK)) continue;
            if (string2.startsWith(INCLUDE_DIRECTIVE)) {
                this.pushInput(string2.substring(INCLUDE_DIRECTIVE.length()).trim());
                continue;
            }
            if (string2.startsWith(DOCINPUT_DIRECTIVE)) {
                this.documentInput(string2.substring(DOCINPUT_DIRECTIVE.length()).trim());
                continue;
            }
            if (string2.startsWith(COLLINPUT_DIRECTIVE)) {
                this.collectionInput(string2.substring(COLLINPUT_DIRECTIVE.length()).trim());
                continue;
            }
            if (string2.startsWith(DEFVAR_DIRECTIVE)) {
                stringArray = string2.substring(DEFVAR_DIRECTIVE.length()).trim();
                this.declareGlobal((String)stringArray, "TEST");
                continue;
            }
            if (string2.startsWith(OPTION_DIRECTIVE)) {
                stringArray = string2.substring(DEFVAR_DIRECTIVE.length()).split("[ \t\r]+");
                if (stringArray.length == 0 || !stringArray[0].equals("wrapped")) continue;
                this.wrappedDisplay = stringArray.length == 1 || stringArray[1].equals("yes");
                continue;
            }
            if (string2.startsWith(TESTNAME_DIRECTIVE)) {
                this.currentTestName = string2.substring(TESTNAME_DIRECTIVE.length()).trim();
                continue;
            }
            if (string2.startsWith(OUTPUT_MARK)) {
                this.refData.setSize(0);
                while ((string2 = this.readLine()) != null && !string2.trim().equals(EOOUTPUT_MARK)) {
                    this.refData.add(string2);
                }
                if (string2 == null) {
                    this.error("missing '##'");
                }
                try {
                    this.execQuery(this.curQuery, "TEST");
                }
                catch (XQueryException xQueryException) {
                }
                catch (Exception exception) {
                    this.error(exception.toString());
                    exception.printStackTrace();
                }
                this.compare(this.getOutput(), this.refData);
                this.clearOutput();
                this.curQuery = "";
                this.currentTestName = null;
                this.queryLine = -1;
                continue;
            }
            if (string2.charAt(0) != '#') {
                this.curQuery = this.curQuery + string2 + '\n';
                if (this.queryLine >= 0) continue;
                this.queryLine = this.currentInput.line;
                this.queryFile = this.currentInput.uri;
                continue;
            }
            this.error("bad line '" + string2 + "'");
        }
        if (this.curQuery.trim().length() > 0) {
            this.error("non-executed query at end? ");
        }
    }

    void error(String string) {
        System.err.println("*** at line " + this.currentInput.line + " in " + this.currentInput.uri + ": " + string);
    }

    String readLine() throws IOException {
        if (this.currentInput == null) {
            return null;
        }
        String string = this.currentInput.reader.readLine();
        while (string == null && this.currentInput.up != null) {
            this.currentInput = this.currentInput.up;
            string = this.currentInput.reader.readLine();
        }
        ++this.currentInput.line;
        return string;
    }

    void pushInput(String string) throws IOException {
        File file = new File(string);
        File file2 = file.isAbsolute() ? file : new File(new File(this.dataPath), string);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file2), "ISO8859_1");
        this.currentInput = new Input(this.currentInput, string);
        this.currentInput.reader = new BufferedReader(inputStreamReader);
    }

    void documentInput(String string) throws IOException, XQueryException {
        this.setDocumentInput(string);
    }

    void collectionInput(String string) {
        System.err.println("collection Input |" + string + "|");
    }

    void declareGlobal(String string, String string2) throws IOException {
        String string3;
        String string4 = "";
        while ((string3 = this.readLine()) != null && !string3.equals(EOOUTPUT_MARK)) {
            if (string3.startsWith(INCLUDE_DIRECTIVE)) {
                this.pushInput(string3.substring(INCLUDE_DIRECTIVE.length()).trim());
                continue;
            }
            string4 = string4 + string3 + '\n';
        }
        if (string3 == null) {
            this.error("missing '##'");
        }
        try {
            this.log.reset();
            Query query = this.compileQuery(string4, string2, (net.xfra.qizxopen.xquery.Log)this.log);
            if (this.log.getErrorCount() != 0) {
                System.err.println("*** variable " + string + " not defined");
                return;
            }
            Value value = this.executeQuery(query);
            this.predefineGlobal(QName.get(string), query.getType());
            this.initGlobal(QName.get(string), value);
        }
        catch (XQueryException xQueryException) {
            this.error(xQueryException.getMessage());
            xQueryException.printStackTrace();
        }
    }

    void execQuery(String string, String string2) throws XQueryException {
        try {
            long l = System.currentTimeMillis();
            this.log.reset();
            Query query = this.compileQuery(string, string2, (net.xfra.qizxopen.xquery.Log)this.log);
            if (this.exprDump && query != null) {
                query.dump(new ExprDump());
            }
            long l2 = System.currentTimeMillis() - l;
            if (this.verbose) {
                System.err.println("parsing & static check time(ms): " + l2);
            }
            if (this.log.getErrorCount() != 0) {
                if (this.verbose) {
                    System.err.println(this.log.getErrorCount() + " parsing/static error(s)");
                }
                return;
            }
            this.nodeDisplay.definePrefixHints(query.getInScopeNS());
            l = System.currentTimeMillis();
            Value value = this.executeQuery(query);
            l2 = System.currentTimeMillis();
            int n = 0;
            if (this.wrappedDisplay) {
                this.output.println("<results>");
            }
            while (value.next()) {
                ++n;
                if (!this.display) continue;
                Item item = value.asItem();
                ItemType itemType = item.getType();
                if (this.wrappedDisplay) {
                    this.output.print(" <item type='" + itemType + "'>");
                }
                if (Type.NODE.accepts(item.getType())) {
                    this.nodeDisplay.output(value.asNode());
                } else if (item.getType() == Type.QNAME) {
                    QName qName = ((QNameValue)item).getValue();
                    this.output.print(query.prefixedName(qName));
                } else {
                    this.output.print(value.asString());
                }
                if (!this.wrappedDisplay) continue;
                this.output.println("</item>");
            }
            if (this.wrappedDisplay) {
                this.output.println("</results>");
            }
            long l3 = System.currentTimeMillis();
            this.output.flush();
            if (this.verbose) {
                System.err.println("eval time(ms): " + (l2 - l) + " display time " + (l3 - l2));
            }
        }
        catch (EvalException evalException) {
            if (this.traceExceptions) {
                evalException.printStackTrace();
            }
            evalException.printStack(this.log, 20);
            if (evalException.getCause() != null && !this.traceExceptions) {
                System.err.println("  caused by: " + evalException.getCause());
            }
        }
        catch (SyntaxException syntaxException) {
            this.output.println("** Syntax: " + syntaxException.getMessage());
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
    }

    void diag(String string, String string2) {
        if (this.firstDiag) {
            System.out.print("====== test");
            if (this.currentTestName != null) {
                System.out.print(" " + this.currentTestName);
            }
            System.out.println(" line " + this.queryLine + " in " + this.queryFile + " fails: ======");
            this.firstDiag = false;
        }
        System.out.print(string);
        System.out.println(string2);
    }

    void compare(String string, Vector vector) {
        this.firstDiag = true;
        boolean bl = true;
        boolean bl2 = string.indexOf("\r\n") >= 0;
        String[] stringArray = string.split(bl2 ? "\r\n" : "\n");
        int n = Math.min(stringArray.length, vector.size());
        int n2 = 0;
        while (n2 < n) {
            String string2 = (String)vector.get(n2);
            if (!stringArray[n2].equals(string2)) {
                if (this.displayDiff) {
                    this.diag("LINE " + n2 + ": ", stringArray[n2]);
                    this.diag("EXPECT: ", string2);
                } else {
                    bl = false;
                }
            }
            ++n2;
        }
        if (stringArray.length > n) {
            if (this.displayDiff) {
                this.diag("## ", "UNEXPECTED:");
                while (n2 < stringArray.length) {
                    this.diag("", stringArray[n2]);
                    ++n2;
                }
            } else {
                bl = false;
            }
        } else if (vector.size() > n) {
            if (this.displayDiff) {
                this.diag("## ", "MISSING:");
                while (n2 < vector.size()) {
                    this.diag("", (String)vector.get(n2));
                    ++n2;
                }
            } else {
                bl = false;
            }
        }
        if (!bl && !this.displayDiff) {
            this.diag("Actual output", ":");
            System.err.print(string);
        }
    }

    String getOutput() {
        this.output.flush();
        return this.stringOut.toString();
    }

    void clearOutput() {
        this.stringOut.getBuffer().setLength(0);
    }

    public class Log
    extends net.xfra.qizxopen.xquery.Log {
        Log(PrintWriter printWriter) {
            this.output = printWriter;
            this.printSource = false;
        }

        public void info(String string) {
            super.info(string);
        }
    }

    static class Input {
        Input up;
        BufferedReader reader;
        int line = 0;
        String uri;

        Input(Input input, String string) {
            this.up = input;
            this.uri = string;
        }
    }
}

