/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.app;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import net.xfra.qizxopen.dm.DataModelException;
import net.xfra.qizxopen.dm.XMLSerializer;
import net.xfra.qizxopen.util.CLOptions;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.DocumentManager;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.Query;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.XQueryProcessor;
import net.xfra.qizxopen.xquery.fn.JavaFunction;
import net.xfra.qizxopen.xquery.impl.Lexer;

public class XQuery
extends XQueryProcessor {
    public String queryFile;
    public boolean verbose = true;
    public boolean push = false;
    public boolean traceJava = false;
    public boolean exprDump = false;
    public boolean display = true;
    public boolean xmlDisplay = true;
    public boolean wrapDisplay = false;
    public boolean clearDocuments = false;
    public String baseURI;
    public String modules = ".";
    public String inputURI = null;
    public String output = null;
    public String[] globals = new String[0];
    public String[] xmloptions = new String[0];
    public String[] appargs = new String[0];
    public String[] class_name = new String[0];
    public String timezone;
    public String collation;
    public int indent = 2;
    public int repeats = 1;
    public boolean traceExceptions = false;
    public boolean traceLex = false;
    Log log = new Log();
    PrintWriter stderr = new PrintWriter(System.err, true);
    XMLSerializer nodeDisplay = new XMLSerializer();
    static CLOptions options = new CLOptions("XQuery");

    XQuery(String[] stringArray) throws IOException, CLOptions.Exception {
        this.nodeDisplay.setIndent(this.indent);
        options.parse(stringArray, this);
    }

    public static void main(String[] stringArray) {
        try {
            XQuery xQuery = new XQuery(stringArray);
            xQuery.run();
            xQuery = null;
            System.gc();
        }
        catch (CLOptions.Exception exception) {
            System.exit(1);
        }
        catch (DataModelException dataModelException) {
            System.err.println("*** error in XML option: " + dataModelException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void run() throws Exception {
        int n;
        this.nodeDisplay = new XMLSerializer();
        int n2 = 0;
        while (n2 < this.xmloptions.length) {
            n = this.xmloptions[n2].indexOf(61);
            if (n < 0) {
                System.err.println("*** illegal XML option: " + this.xmloptions[n2]);
                return;
            }
            this.nodeDisplay.setOption(this.xmloptions[n2].substring(0, n), this.xmloptions[n2].substring(n + 1));
            ++n2;
        }
        n = 0;
        while (n < this.class_name.length) {
            this.authorizeClass(this.class_name[n]);
            ++n;
        }
        Object var3_3 = null;
        if (this.output != null) {
            this.nodeDisplay.setOutput(new FileOutputStream(this.output), this.nodeDisplay.getEncoding());
        }
        JavaFunction.trace = this.traceJava;
        Lexer.debug = this.traceLex;
        this.setModuleManager(new ModuleManager(this.modules));
        this.setDocumentManager(new DocumentManager(this.baseURI));
        if (this.inputURI != null) {
            this.setDocumentInput(this.inputURI);
        }
        if (this.timezone != null) {
            this.setImplicitTimezone(this.timezone);
        }
        if (this.collation != null) {
            this.setDefaultCollation(this.collation);
        }
        this.initGlobal(QName.get("arguments"), this.appargs);
        if (this.queryFile == null) {
            this.interactive();
        } else {
            boolean bl = this.queryFile.equals("-");
            if (this.queryFile.startsWith("-") && !bl) {
                options.printHelp(System.err);
                System.exit(1);
            }
            InputStreamReader inputStreamReader = bl ? new InputStreamReader(System.in) : new FileReader(this.queryFile);
            this.execute(inputStreamReader, bl ? "stdin" : this.queryFile);
            System.gc();
        }
    }

    void interactive() throws IOException {
        Object object;
        if (this.verbose) {
            object = "Qizx/open ";
            System.err.println((String)object + this.getVersion() + " - copyright 2003-2004 Xavier Franc");
            System.err.println("[interactive mode]");
        }
        object = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String string;
            System.out.print("XQuery> ");
            String string2 = ((BufferedReader)object).readLine();
            if (string2 == null) break;
            if (string2.length() == 0) continue;
            if (string2.charAt(0) != '\\') {
                string = string2;
            } else {
                string = string2.substring(1);
                while ((string2 = ((BufferedReader)object).readLine()) != null && !string2.equals(".")) {
                    string = string + '\n' + string2;
                }
            }
            try {
                this.log.reset();
                Query query = this.compileQuery(string, "<input>", this.log);
                this.execAndPrint(query);
            }
            catch (XQueryException xQueryException) {
                this.stderr.println("*** " + xQueryException.getMessage());
                if (!this.traceExceptions) continue;
                xQueryException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    void execute(Reader reader, String string) throws IOException, XQueryException {
        block3: {
            try {
                this.log.reset();
                Query query = this.compileQuery(reader, string, this.log);
                this.log.flush();
                if (this.log.getErrorCount() != 0) {
                    this.stderr.println(this.log.getErrorCount() + " parsing/static error(s)");
                    break block3;
                }
                this.execAndPrint(query);
            }
            catch (Exception exception) {
                System.err.println("*** " + exception.getMessage());
                if (!this.traceExceptions) break block3;
                exception.printStackTrace();
            }
        }
    }

    void execAndPrint(Query query) throws IOException, XQueryException, DataModelException {
        int n = 0;
        while (n < this.globals.length) {
            int n2 = this.globals[n].indexOf(61);
            if (n2 < 0) {
                System.err.println("illegal variable initializer: " + this.globals[n]);
                return;
            }
            this.initGlobal(XQueryProcessor.toLocalNS(this.globals[n].substring(0, n2)), this.globals[n].substring(n2 + 1));
            ++n;
        }
        if (this.exprDump && query != null) {
            query.dump(new ExprDump());
        }
        QName qName = QName.get("query-results");
        QName qName2 = QName.get("item");
        QName qName3 = QName.get("type");
        int n3 = 0;
        while (n3 < this.repeats) {
            block27: {
                try {
                    long l;
                    if (this.clearDocuments) {
                        String string = this.getDocumentManager().getBaseURI();
                        this.setDocumentManager(new DocumentManager(string));
                    }
                    long l2 = System.currentTimeMillis();
                    if (!this.push) {
                        Value value = this.executeQuery(query);
                        l = System.currentTimeMillis();
                        int n4 = 0;
                        this.nodeDisplay.reset();
                        this.nodeDisplay.definePrefixHints(query.getInScopeNS());
                        if (this.display && this.xmlDisplay && this.wrapDisplay) {
                            this.nodeDisplay.startDocument();
                            this.nodeDisplay.startElement(qName);
                        }
                        while (value.next()) {
                            Item item = value.asItem();
                            if (this.display) {
                                if (this.xmlDisplay) {
                                    if (this.wrapDisplay) {
                                        this.nodeDisplay.startElement(qName2);
                                        this.nodeDisplay.attribute(qName3, value.getType().toString());
                                    }
                                    if (Type.NODE.accepts(item.getType())) {
                                        this.nodeDisplay.traverse(value.asNode(), true);
                                    } else {
                                        this.nodeDisplay.text(value.asString());
                                        if (!this.wrapDisplay) {
                                            this.nodeDisplay.text(" ");
                                        }
                                    }
                                    if (this.wrapDisplay) {
                                        this.nodeDisplay.endElement(qName2);
                                    }
                                } else {
                                    if (this.wrapDisplay) {
                                        System.out.print(n4 + " [" + value.getType() + "] ");
                                    }
                                    if (Type.NODE.accepts(item.getType())) {
                                        this.nodeDisplay.output(value.asNode());
                                        this.nodeDisplay.terminate();
                                    } else {
                                        System.out.println(value.asString());
                                    }
                                }
                            }
                            ++n4;
                        }
                        if (this.display && this.xmlDisplay) {
                            if (this.wrapDisplay) {
                                this.nodeDisplay.endElement(qName);
                                this.nodeDisplay.endDocument();
                            }
                            this.nodeDisplay.terminate();
                        }
                        if (this.verbose) {
                            System.err.println("-> " + n4 + " item(s)");
                        }
                    } else {
                        this.executeQuery(query, this.nodeDisplay);
                        l = System.currentTimeMillis();
                    }
                    long l3 = System.currentTimeMillis();
                    if (this.verbose) {
                        System.err.println("evaluation time: " + (l - l2) + " ms, display time: " + (l3 - l) + " ms");
                    }
                }
                catch (EvalException evalException) {
                    if (this.traceExceptions) {
                        evalException.printStackTrace();
                    }
                    evalException.printStack(this.log, 20);
                    if (evalException.getCause() == null || this.traceExceptions) break block27;
                    System.err.println("  caused by: " + evalException.getCause());
                }
            }
            ++n3;
        }
    }

    static {
        options.declare("-baseURI", 1, "default base URI for documents and modules");
        options.declare("-modules", 1, "base URI for resolving module locations");
        options.declare("-input", "inputURI", 1, "URI for input()");
        options.declare("-D", "globals", 2, "variable_name=value!initialize a global variable defined in the query.");
        options.declare("-X", "xmloptions", 2, "option=value!set a XML serialization option.");
        options.declare("-serial", "push", 3, "serial output: the query must evaluate as a well-formed document.");
        options.declare("-out", "output", 1, "output file (defaults to standard output)");
        options.declare("-timezone", 1, "implicit timezone in duration format");
        options.declare("-collation", 1, "default collation");
        options.declare("-q", "verbose", 4, "quiet mode");
        options.declare("-mute", "display", 4, "no display of results");
        options.declare("--", "appargs", 5, "pass all following arguments to XQuery processor in variable 'arguments'");
        options.declare("-jt", "traceJava", 3, "trace Java extension functions");
        options.declare("-xd", "xmlDisplay", 4, null);
        options.declare("-wrap", "wrapDisplay", 3, "do not wrap results in descriptor tags");
        options.declare("-ext", "class_name", 1, "allow this class as Java extension");
        options.declare("-help", null, 6, "print this help");
        options.argument("<query file>", "queryFile", 0, "a file containing a query to execute.\n               If equal to '-', use the standard input.\n               If absent, enter interactive mode.");
        options.declare("-r", "repeats", 1, null);
        options.declare("-d", "exprDump", 3, null);
        options.declare("-tex", "traceExceptions", 3, null);
        options.declare("-tlex", "traceLex", 3, null);
        options.declare("-cld", "clearDocuments", 3, null);
    }
}

