/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.dm;

import java.util.ArrayList;
import net.xfra.qizxopen.dm.FONIDocument;
import net.xfra.qizxopen.dm.FONIWriter;
import net.xfra.qizxopen.util.NSTable;
import net.xfra.qizxopen.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class IDocument
extends FONIWriter
implements FONIDocument {
    Locator currentLocator;
    static final int HEADER_OFFSET = 0;
    static final int PARENT_OFFSET = 1;
    static final int NEXT_OFFSET = 2;
    static final int ATTR_OFFSET = 3;
    static final int CONTENT_OFFSET = 3;
    static final int KIND_BITS = 3;
    static final int KIND_MASK = 7;
    static final int HAS_CHILDREN = 8;
    static final int NAME_SHIFT = 4;
    static final int NAME_BITS = 12;
    static final int NAME_MASK = 4095;
    static final int ATTR_SHIFT = 16;
    static final int ATTR_BITS = 9;
    static final int ATTR_MASK = 511;
    static final int NS_SHIFT = 25;
    static final int ATTR_NAME_SHIFT = 2;
    static final int BLOCK_SHIFT = 9;
    static final int BLOCK_SIZE = 512;
    static final int BLOCK_MASK = 511;
    static final int CHARBLOCK_SHIFT = 12;
    static final int CHARBLOCK_SIZE = 4096;
    static final int CHARBLOCK_MASK = 4095;
    protected int docId;
    private String baseURI;
    private NSTable elementNames = new NSTable();
    private NSTable otherNames = new NSTable();
    private ArrayList prefixMapping;
    private ArrayList namespaceStack = new ArrayList();
    int[][] blocks;
    int blockCnt;
    int docSize;
    int curNode;
    int prevNode = 0;
    int lastNode;
    int charCnt;
    int charChunks;
    int textChunks;
    char[] charBuffer = new char[2048];
    int charPtr;
    char[][] charBlocks;
    int lastCharBlock;
    int charBlockPtr;
    ArrayList bigStrings = new ArrayList();

    public IDocument() {
        this.blocks = new int[8][];
        this.blocks[0] = new int[512];
        this.blockCnt = 1;
        this.charBlocks = new char[8][];
        this.charBlocks[0] = new char[4096];
        this.lastCharBlock = 0;
        this.charBlockPtr = 1;
        this.docSize = 3;
        this.openNode(1);
        this.curNode = 3;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public int getRootNode() {
        return 3;
    }

    public void setDocId(int n) {
        this.docId = n;
    }

    public int getDocId() {
        return this.docId;
    }

    public QName getName(int n) {
        switch (this.getKind(n)) {
            case 2: {
                return this.elementNames.getName(this.getNameId(n));
            }
            case 5: {
                return this.otherNames.getName(this.getNameId(n));
            }
        }
        return null;
    }

    public int getNameId(int n) {
        return this.hNameId(this.dataAt(n));
    }

    public QName pnGetName(int n) {
        return this.otherNames.getName(this.getNameId(n));
    }

    public int pnGetNameId(int n) {
        return this.getNameId(n);
    }

    public int getParent(int n) {
        return this.dataAt(n + 1);
    }

    public int getNextSibling(int n) {
        return this.dataAt(n + 2);
    }

    public int getNodeNext(int n) {
        int n2 = this.getFirstChild(n);
        return n2 != 0 ? n2 : this.getNodeAfter(n);
    }

    public int getNodeAfter(int n) {
        int n2;
        while ((n2 = this.getNextSibling(n)) == 0) {
            int n3 = this.getParent(n);
            if (n3 == 0) {
                return 0;
            }
            n = n3;
        }
        return n2;
    }

    public int getNodeSpan(int n) {
        int n2 = this.getNodeNext(n);
        if (n2 == 0) {
            n2 = this.docSize;
        }
        return n2 - n;
    }

    public int getFirstChild(int n) {
        int n2 = this.dataAt(n);
        int n3 = n2 & 7;
        if (n3 != 2 && n3 != 1 || (n2 & 8) == 0) {
            return 0;
        }
        int n4 = n + 3 + 2 * (this.hAttrCount(n2) + this.hNamespaceCount(n2));
        return n4;
    }

    public FONIDocument.NodeIterator childrenIterator(int n) {
        return new SiblingIterator(-this.getFirstChild(n));
    }

    public int getAttrCount(int n) {
        return this.hAttrCount(this.dataAt(n + 0));
    }

    public FONIDocument.NodeIterator attrIterator(int n) {
        return new AttrIterator(n);
    }

    public int getAttribute(int n, int n2) {
        int n3 = n + 3 + 2 * this.getNamespaceCount(n);
        int n4 = this.getAttrCount(n);
        while (n4 > 0) {
            if (this.getNameId(n3) == n2) {
                return n3;
            }
            --n4;
            n3 += 2;
        }
        return 0;
    }

    public String getStringValue(int n) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(this.getNodeSpan(n));
                int n2 = this.getFirstChild(n);
                while (n2 != 0) {
                    this.recStringValue(n2, stringBuffer);
                    n2 = this.getNextSibling(n2);
                }
                return stringBuffer.toString();
            }
            case 3: 
            case 7: {
                return this.decodeString(this.dataAt(n + 1));
            }
        }
        return this.decodeString(this.dataAt(n + 3));
    }

    void recStringValue(int n, StringBuffer stringBuffer) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                int n2 = this.getFirstChild(n);
                while (n2 != 0) {
                    this.recStringValue(n2, stringBuffer);
                    n2 = this.getNextSibling(n2);
                }
                break;
            }
            case 4: {
                this.decodeString(this.dataAt(n + 3), stringBuffer);
            }
        }
    }

    public String pnGetStringValue(int n) {
        return this.decodeString(this.dataAt(n + 1));
    }

    public char[] getCharValue(int n, int n2) {
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                throw new RuntimeException("not allowed on non-atoms");
            }
            case 3: 
            case 7: {
                return this.decodeChars(this.dataAt(n + 1), n2);
            }
        }
        return this.decodeChars(this.dataAt(n + 3), n2);
    }

    public char[] pnGetCharValue(int n, int n2) {
        return this.decodeChars(this.dataAt(n + 1), n2);
    }

    public int getDefinedNSCount(int n) {
        return this.getNamespaceCount(n);
    }

    public FONIDocument.NodeIterator namespaceIterator(int n, boolean bl) {
        if (bl) {
            while (n != 0 && this.getNamespaceCount(n) == 0) {
                n = this.getParent(n);
            }
        }
        return new NSIterator(n);
    }

    public int getElementNameCount() {
        return this.elementNames.size();
    }

    public QName getElementName(int n) {
        return this.elementNames.getName(n);
    }

    public int internElementName(QName qName) {
        return this.elementNames.find(qName);
    }

    public int getOtherNameCount() {
        return this.otherNames.size();
    }

    public QName getOtherName(int n) {
        return this.otherNames.getName(n);
    }

    public int internOtherName(QName qName) {
        return this.otherNames.find(qName);
    }

    public void setDocumentLocator(Locator locator) {
        this.currentLocator = locator;
    }

    public void startDocument() throws SAXException {
        if (this.currentLocator != null) {
            this.baseURI = this.currentLocator.getSystemId();
        }
    }

    public void endDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        int n2;
        this.endText();
        int n3 = this.openNode(2);
        if (string2 == null || string2.length() == 0) {
            string = "";
            string2 = string3;
        }
        int n4 = this.elementNames.enter(string, string2);
        int n5 = attributes == null ? 0 : attributes.getLength();
        int n6 = 0;
        int n7 = n3 + 3;
        if (this.prefixMapping != null) {
            if (this.namespaceStack.size() > 0) {
                ArrayList arrayList = (ArrayList)this.namespaceStack.get(this.namespaceStack.size() - 1);
                n2 = arrayList.size() - 2;
                while (n2 >= 0) {
                    int n8 = this.prefixMapping.size() - 2;
                    while (n8 >= 0) {
                        if (arrayList.get(n2).equals(this.prefixMapping.get(n8))) break;
                        n8 -= 2;
                    }
                    if (n8 < 0) {
                        this.prefixMapping.add(0, arrayList.get(n2));
                        this.prefixMapping.add(1, arrayList.get(n2 + 1));
                    }
                    n2 -= 2;
                }
            }
            n6 = this.prefixMapping.size();
            n = 0;
            while (n < n6) {
                n2 = this.otherNames.enter("", (String)this.prefixMapping.get(n));
                this.setData(n7++, 7 + (n2 << 4));
                this.setData(n7++, this.storeString((String)this.prefixMapping.get(n + 1)));
                n += 2;
            }
            this.namespaceStack.add(this.prefixMapping);
            this.prefixMapping = null;
        }
        n = 0;
        while (n < n5) {
            n2 = this.otherNames.enter(attributes.getURI(n), attributes.getLocalName(n));
            this.setData(n7++, 3 + (n2 << 4));
            this.setData(n7++, this.storeString(attributes.getValue(n)));
            ++n;
        }
        this.docSize = n7;
        this.setData(n3 + 0, 2 + (n4 << 4) + (n5 << 16) + (n6 / 2 << 25));
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.endText();
        this.closeNode();
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = this.charPtr + n2;
        if (n3 > this.charBuffer.length) {
            char[] cArray2 = this.charBuffer;
            this.charBuffer = new char[n3 + 1000];
            System.arraycopy(cArray2, 0, this.charBuffer, 0, this.charPtr);
        }
        System.arraycopy(cArray, n, this.charBuffer, this.charPtr, n2);
        this.charPtr = n3;
        ++this.charChunks;
        this.charCnt += n2;
    }

    public void characters(String string) {
        this.characters(string.toCharArray(), 0, string.length());
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.endText();
        int n = this.openNode(5);
        int n2 = this.otherNames.enter("", string);
        this.setData(n + 0, this.dataAt(n + 0) + (n2 << 4));
        this.setData(this.docSize++, this.storeString(string2));
        this.closeNode();
    }

    public void skippedEntity(String string) throws SAXException {
        throw new SAXException("skipped entity '" + string + "': cannot be handled");
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.prefixMapping == null) {
            this.prefixMapping = new ArrayList();
        }
        this.prefixMapping.add(string);
        this.prefixMapping.add(string2);
    }

    public void endPrefixMapping(String string) throws SAXException {
    }

    public void comment(char[] cArray, int n, int n2) {
        this.endText();
        int n3 = this.openNode(6);
        this.setData(this.docSize++, this.storeString(new String(cArray, n, n2)));
        this.closeNode();
    }

    public void startCDATA() {
    }

    public void endCDATA() {
    }

    public void startDTD(String string, String string2, String string3) {
    }

    public void endDTD() {
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public int getCurrentNode() {
        return this.curNode;
    }

    int openNode(int n) {
        int n2 = this.docSize;
        this.docSize += 3;
        if (this.prevNode != 0) {
            this.setData(this.prevNode + 2, n2);
        }
        this.setData(n2 + 0, n);
        this.setData(n2 + 1, this.curNode);
        this.setData(n2 + 2, 0);
        this.curNode = this.lastNode = n2;
        this.prevNode = 0;
        return this.curNode;
    }

    void closeNode() {
        this.prevNode = this.curNode;
        this.curNode = this.getParent(this.curNode);
        if (this.curNode != 0) {
            this.setFlag(this.curNode, 8);
        }
    }

    void endText() {
        if (this.charPtr > 0) {
            ++this.textChunks;
            this.openNode(4);
            this.setData(this.docSize++, this.storeString());
            this.closeNode();
        }
        this.charPtr = 0;
    }

    void setFlag(int n, int n2) {
        this.setData(n + 0, this.dataAt(n + 0) | n2);
    }

    void checkDump(int n, int n2, int n3) {
        System.out.print(n);
        int n4 = 0;
        while (n4 < n3) {
            System.out.print("  ");
            ++n4;
        }
        ++n3;
        switch (this.getKind(n)) {
            case 1: 
            case 2: {
                System.out.println("ELEMENT " + this.getName(n));
                AttrIterator attrIterator = new AttrIterator(n);
                while (attrIterator.next()) {
                    this.checkDump(attrIterator.currentId(), n, n3);
                }
                int n5 = this.getFirstChild(n);
                while (n5 != 0) {
                    this.checkDump(n5, n, n3);
                    n5 = this.getNextSibling(n5);
                }
                break;
            }
            case 3: {
                System.out.println("  ATTR " + this.getName(n) + " |" + this.getStringValue(n) + "|");
                break;
            }
            case 4: {
                System.out.println("TEXT |" + this.getStringValue(n) + "|");
                break;
            }
            case 6: {
                System.out.println("COMMENT |" + this.getStringValue(n) + "|");
                break;
            }
            case 5: {
                System.out.println("PI |" + this.getStringValue(n) + "|");
                break;
            }
            default: {
                System.err.println("*** bad node id=" + n + " kind=" + this.getKind(n));
            }
        }
    }

    public int estimateMemorySize() {
        return this.blockCnt * 512 * 4 + this.lastCharBlock * 4096 * 2 + this.bigStrings.size() * 4096;
    }

    private int dataAt(int n) {
        return this.blocks[n >> 9][n & 0x1FF];
    }

    private void setData(int n, int n2) {
        int n3 = n >> 9;
        int n4 = n & 0x1FF;
        if (n3 >= this.blockCnt) {
            if (this.blockCnt >= this.blocks.length) {
                int[][] nArray = this.blocks;
                this.blocks = new int[nArray.length + 64][];
                System.arraycopy(nArray, 0, this.blocks, 0, nArray.length);
            }
            this.blocks[this.blockCnt++] = new int[512];
        }
        this.blocks[n3][n4] = n2;
    }

    public int getKind(int n) {
        return this.dataAt(n + 0) & 7;
    }

    private final int hNameId(int n) {
        return n >> 4 & 0xFFF;
    }

    int getNamespaceCount(int n) {
        return this.hNamespaceCount(this.dataAt(n));
    }

    private final int hNamespaceCount(int n) {
        return n >> 25;
    }

    private final int hAttrCount(int n) {
        return n >> 16 & 0x1FF;
    }

    int storeString(String string) {
        int n = string.length();
        if (n > this.charBuffer.length) {
            return this.storeBigString(string);
        }
        string.getChars(0, n, this.charBuffer, 0);
        this.charPtr = n;
        int n2 = this.storeString();
        this.charPtr = 0;
        return n2;
    }

    int storeString() {
        if (this.charPtr > 2048) {
            return this.storeBigString(new String(this.charBuffer, 0, this.charPtr));
        }
        int n = this.charPtr + 1;
        if (this.charBlockPtr + n > 4096) {
            if (++this.lastCharBlock >= this.charBlocks.length) {
                char[][] cArray = this.charBlocks;
                this.charBlocks = new char[cArray.length + 100][];
                System.arraycopy(cArray, 0, this.charBlocks, 0, cArray.length);
            }
            this.charBlocks[this.lastCharBlock] = new char[4096];
            this.charBlockPtr = 0;
        }
        int n2 = this.lastCharBlock * 4096 + this.charBlockPtr;
        char[] cArray = this.charBlocks[this.lastCharBlock];
        cArray[this.charBlockPtr] = (char)this.charPtr;
        System.arraycopy(this.charBuffer, 0, cArray, this.charBlockPtr + 1, this.charPtr);
        this.charBlockPtr += n;
        return n2 << 1;
    }

    int storeBigString(String string) {
        int n = this.bigStrings.size();
        this.bigStrings.add(string);
        return (n << 1) + 1;
    }

    String decodeString(int n) {
        if ((n & 1) != 0) {
            return (String)this.bigStrings.get(n >> 1);
        }
        char[] cArray = this.charBlocks[(n >>= 1) >> 12];
        int n2 = n & 0xFFF;
        return new String(cArray, n2 + 1, (int)cArray[n2]);
    }

    void decodeString(int n, StringBuffer stringBuffer) {
        if ((n & 1) != 0) {
            stringBuffer.append((String)this.bigStrings.get(n >> 1));
        } else {
            char[] cArray = this.charBlocks[(n >>= 1) >> 12];
            int n2 = n & 0xFFF;
            stringBuffer.append(cArray, n2 + 1, (int)cArray[n2]);
        }
    }

    char[] decodeChars(int n, int n2) {
        if ((n & 1) != 0) {
            String string = (String)this.bigStrings.get(n >> 1);
            char[] cArray = new char[string.length() + n2];
            string.getChars(0, string.length(), cArray, n2);
            return cArray;
        }
        char[] cArray = this.charBlocks[(n >>= 1) >> 12];
        int n3 = n & 0xFFF;
        char c = cArray[n3];
        char[] cArray2 = new char[c + n2];
        System.arraycopy(cArray, n3 + 1, cArray2, n2, c);
        return cArray2;
    }

    protected class NSIterator
    extends AttrIterator {
        NSIterator(int n) {
            this.count = n == 0 ? 0 : IDocument.this.getNamespaceCount(n);
            this.offset = n + 3 - 2;
        }

        public boolean next() {
            if (this.count <= 0) {
                return false;
            }
            --this.count;
            this.offset += 2;
            return true;
        }

        public int currentId() {
            return this.offset;
        }

        public FONIDocument.NodeIterator reborn() {
            return new NSIterator(this.startId);
        }
    }

    public class AttrIterator
    implements FONIDocument.NodeIterator {
        protected int startId;
        protected int offset;
        protected int count = 0;

        AttrIterator() {
        }

        AttrIterator(int n) {
            this.startId = n;
            int n2 = IDocument.this.dataAt(n + 0);
            this.offset = -(n + 3 + 2 * IDocument.this.hNamespaceCount(n2));
            this.count = IDocument.this.hAttrCount(n2);
        }

        public boolean next() {
            if (this.count <= 0) {
                return false;
            }
            --this.count;
            this.offset = this.offset < 0 ? -this.offset : (this.offset += 2);
            return true;
        }

        public int currentId() {
            return this.offset < 0 ? -this.offset : this.offset;
        }

        public FONIDocument.NodeIterator reborn() {
            return new AttrIterator(this.startId);
        }
    }

    protected class SiblingIterator
    implements FONIDocument.NodeIterator {
        int startId;
        int curId;

        SiblingIterator(int n) {
            this.startId = this.curId = n;
        }

        public boolean next() {
            this.curId = this.curId < 0 ? -this.curId : IDocument.this.getNextSibling(this.curId);
            return this.curId != 0;
        }

        public int currentId() {
            return this.curId;
        }

        public FONIDocument.NodeIterator reborn() {
            return new SiblingIterator(this.startId);
        }
    }
}

