/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.app;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.xfra.qizxopen.util.CLOptions;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.DocumentManager;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.Query;
import net.xfra.qizxopen.xquery.SAXXQueryProcessor;
import org.xml.sax.InputSource;

public class XQT
extends SAXXQueryProcessor {
    public String queryFile;
    public String styleSheet;
    public String baseURI;
    public String modules = ".";
    public String inputURI = null;
    public String output = "out.xml";
    public String[] globals = new String[0];
    public String[] appargs = new String[0];
    public String timezone;
    public String collation;
    Log log = new Log();
    PrintWriter stderr = new PrintWriter(System.err, true);

    XQT() {
    }

    public static void main(String[] stringArray) {
        block5: {
            CLOptions cLOptions = new CLOptions("XQT");
            cLOptions.declare("-sheet", "styleSheet", 1, "XSLT style sheet used as second stage");
            cLOptions.declare("-baseURI", 1, "default base URI for documents and modules");
            cLOptions.declare("-modules", 1, "base URI for resolving module locations");
            cLOptions.declare("-input", "inputURI", 1, "URI for input()");
            cLOptions.declare("-D", "globals", 2, "variable_name=value!initialize a global variable defined in the query.");
            cLOptions.declare("-out", "output", 1, "output file (defaults to standard output)");
            cLOptions.declare("-timezone", 1, "implicit timezone in duration format");
            cLOptions.declare("-collation", 1, "default collation");
            cLOptions.declare("--", "appargs", 5, "pass all following arguments to XQuery processor in variable 'arguments'");
            cLOptions.declare("-help", null, 6, "print this help");
            cLOptions.argument("<query file>", "queryFile", 0, "a file containing a query to execute. if '-', use standard input.\n               If absent, enter interactive mode.");
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                XQT xQT = new XQT();
                cLOptions.parse(stringArray, xQT);
                xQT.setModuleManager(new ModuleManager(xQT.modules));
                xQT.setDocumentManager(new DocumentManager(xQT.baseURI));
                xQT.initGlobal(QName.get("arguments"), xQT.appargs);
                if (xQT.queryFile == null || xQT.styleSheet == null) {
                    cLOptions.printHelp(System.err);
                    System.exit(1);
                    break block5;
                }
                long l = System.currentTimeMillis();
                Templates templates = transformerFactory.newTemplates(new StreamSource(new File(xQT.styleSheet).getAbsoluteFile()));
                System.err.println(" xslt compilation: " + (System.currentTimeMillis() - l));
                l = System.currentTimeMillis();
                FileOutputStream fileOutputStream = new FileOutputStream(xQT.output);
                StreamResult streamResult = new StreamResult(fileOutputStream);
                Transformer transformer = templates.newTransformer();
                Log log = new Log();
                Query query = xQT.compileQuery(new File(xQT.queryFile), log);
                xQT.setQuery(query);
                InputSource inputSource = null;
                if (xQT.inputURI != null) {
                    inputSource = new InputSource(xQT.inputURI);
                }
                transformer.transform(new SAXSource(xQT, inputSource), streamResult);
                System.err.println(" total running time: " + (System.currentTimeMillis() - l));
            }
            catch (CLOptions.Exception exception) {
                System.exit(1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

