/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.AtomicType;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;

public class BooleanType
extends AtomicType {
    public String getShortName() {
        return "boolean";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        ItemType itemType = value.getType();
        boolean bl = false;
        try {
            if (itemType == Type.BOOLEAN || Type.NUMERIC.accepts(itemType)) {
                return new SingleBoolean(value.asBoolean());
            }
            String string = value.asString();
            if (string.equals("true") || string.equals("1")) {
                return new SingleBoolean(true);
            }
            if (string.equals("false") || string.equals("0")) {
                return new SingleBoolean(false);
            }
            throw new TypeException("cannot cast to xs:boolean: " + string);
        }
        catch (TypeException typeException) {
            throw new TypeException("cannot cast to xs:boolean: " + typeException.getMessage());
        }
    }
}

