/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import java.text.Collator;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.dt.BaseValue;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.SingleBoolean;

public abstract class BooleanValue
extends BaseValue {
    public BooleanValue() {
        this.itemType = Type.BOOLEAN;
    }

    public Item asItem() throws TypeException {
        return new SingleBoolean(this.asBoolean());
    }

    public double asDouble() throws TypeException {
        return Conversion.toDouble(this.asBoolean());
    }

    public long asInteger() throws TypeException {
        return Conversion.toInteger(this.asBoolean());
    }

    public String asString() throws TypeException {
        return Conversion.toString(this.asBoolean());
    }

    public int compareTo(Item item, Collator collator, int n) throws TypeException {
        if (!Type.BOOLEAN.accepts(item.getType())) {
            return 2;
        }
        boolean bl = item.asBoolean();
        return this.asBoolean() == bl ? 0 : (bl ? -1 : 1);
    }
}

