/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.GMonth;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.MomentType;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleMoment;
import net.xfra.qizxopen.xquery.dt.StringType;

public class GMonthType
extends MomentType {
    public String getShortName() {
        return "gMonth";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        GMonth gMonth;
        block5: {
            ItemType itemType = value.getType();
            gMonth = null;
            try {
                if (itemType instanceof StringType) {
                    gMonth = GMonth.parseGMonth(value.asString());
                    break block5;
                }
                if (Type.INTEGER.accepts(itemType)) {
                    gMonth = new GMonth((int)value.asInteger(), 0, 0, 0);
                    break block5;
                }
                if (itemType == Type.DATE || itemType == Type.DATE_TIME) {
                    gMonth = new GMonth(((MomentValue)value.asItem()).getValue());
                    break block5;
                }
                throw new DateTimeException("invalid type " + itemType);
            }
            catch (DateTimeException dateTimeException) {
                throw new TypeException("cannot cast to xs:gMonth : " + dateTimeException.getMessage());
            }
        }
        return new SingleMoment(gMonth, Type.G_MONTH);
    }
}

