/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.util.Binary;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.BinaryType;
import net.xfra.qizxopen.xquery.dt.BinaryValue;
import net.xfra.qizxopen.xquery.dt.SingleBinary;
import net.xfra.qizxopen.xquery.dt.StringType;

public class HexBinaryType
extends BinaryType {
    public String getShortName() {
        return "hexBinary";
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        Binary binary;
        block4: {
            ItemType itemType = value.getType();
            binary = null;
            try {
                if (itemType instanceof StringType) {
                    binary = Binary.parseHexBinary(value.asString());
                    break block4;
                }
                if (itemType instanceof BinaryType) {
                    binary = ((BinaryValue)value).getValue();
                    break block4;
                }
                throw new IllegalArgumentException("invalid type " + itemType);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new TypeException("cannot cast to xs:hexBinary : " + illegalArgumentException.getMessage());
            }
        }
        return new SingleBinary(binary, Type.HEX_BINARY);
    }
}

