/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.dt.Conversion;
import net.xfra.qizxopen.xquery.dt.DecimalType;
import net.xfra.qizxopen.xquery.dt.SingleInteger;

public class IntegerType
extends DecimalType {
    public String getShortName() {
        return "integer";
    }

    protected long upperBound() {
        return Long.MAX_VALUE;
    }

    protected long lowerBound() {
        return Long.MIN_VALUE;
    }

    public Value cast(Value value, EvalContext evalContext) throws TypeException {
        ItemType itemType = value.getType();
        long l = 0L;
        try {
            if (Type.STRING.accepts(itemType)) {
                l = Conversion.toInteger(value.asString());
            } else if (Type.INTEGER.accepts(itemType)) {
                l = value.asInteger();
            } else if (Type.NUMERIC.accepts(itemType)) {
                l = (long)value.asDouble();
            } else {
                throw new TypeException("invalid type " + itemType);
            }
            if (l < this.lowerBound() || l > this.upperBound()) {
                throw new TypeException("value beyond limits");
            }
        }
        catch (TypeException typeException) {
            throw new TypeException("cannot cast to xs:" + this.getShortName() + " : " + typeException.getMessage());
        }
        return new SingleInteger(l, this);
    }
}

