/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.dt;

import net.xfra.qizxopen.dm.NodeTest;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;

public class NodeType
extends ItemType {
    public NodeTest nodeTest;

    public NodeType(NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.parent = Type.NODE;
    }

    public boolean accepts(Type type) {
        if (!((type = type.getItemType()) instanceof NodeType)) {
            return false;
        }
        NodeTest nodeTest = ((NodeType)type).nodeTest;
        return this.nodeTest == null || nodeTest != null && this.nodeTest.accepts(nodeTest.getNodeKind(), null);
    }

    public boolean acceptsItem(Item item) {
        if (!item.isNode()) {
            return false;
        }
        try {
            Node node = item.asNode();
            return this.nodeTest == null || this.nodeTest.accepts(node);
        }
        catch (XQueryException xQueryException) {
            xQueryException.printStackTrace();
            return false;
        }
    }

    public void dump(ExprDump exprDump) {
        exprDump.println("NodeType");
        exprDump.display("test", this.nodeTest == null ? null : this.nodeTest.toString());
    }

    public String toString(StaticContext staticContext) {
        return this.toString();
    }

    public String toString() {
        int n;
        int n2 = n = this.nodeTest == null ? -1 : this.nodeTest.getNodeKind();
        if (n < 0) {
            return "node()";
        }
        return NodeType.nodeKind(n) + "()";
    }

    public String getShortName() {
        return "node";
    }

    public static String nodeKind(int n) {
        switch (n) {
            case 1: {
                return "document";
            }
            case 2: {
                return "element";
            }
            case 4: {
                return "text";
            }
            case 6: {
                return "comment";
            }
            case 5: {
                return "processing-instruction";
            }
            case 3: {
                return "attribute";
            }
            case 7: {
                return "namespace";
            }
        }
        return "illegal node";
    }

    public static ItemType getTypeByKind(int n) {
        switch (n) {
            case 1: {
                return Type.DOCUMENT;
            }
            case 2: {
                return Type.ELEMENT;
            }
            case 3: {
                return Type.ATTRIBUTE;
            }
            case 4: {
                return Type.TEXT;
            }
            case 5: {
                return Type.PI;
            }
            case 6: {
                return Type.COMMENT;
            }
            case 7: {
                return Type.NAMESPACE;
            }
        }
        throw new RuntimeException("wrong node kind " + n);
    }
}

