/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.fn;

import net.xfra.qizxopen.util.time.Date;
import net.xfra.qizxopen.util.time.DateTimeBase;
import net.xfra.qizxopen.util.time.DateTimeException;
import net.xfra.qizxopen.util.time.Duration;
import net.xfra.qizxopen.xquery.EmptyException;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.MomentValue;
import net.xfra.qizxopen.xquery.dt.SingleDuration;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.op.Expression;

public class GetTimezoneFromDate
extends Function {
    static Prototype[] protos = new Prototype[]{Prototype.fn("get-timezone-from-date", Type.DURATION.opt, class$net$xfra$qizxopen$xquery$fn$GetTimezoneFromDate$Exec == null ? (class$net$xfra$qizxopen$xquery$fn$GetTimezoneFromDate$Exec = GetTimezoneFromDate.class$("net.xfra.qizxopen.xquery.fn.GetTimezoneFromDate$Exec")) : class$net$xfra$qizxopen$xquery$fn$GetTimezoneFromDate$Exec).arg("op", (Type)Type.DATE.opt)};
    static /* synthetic */ Class class$net$xfra$qizxopen$xquery$fn$GetTimezoneFromDate$Exec;

    public Prototype[] getProtos() {
        return protos;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Exec
    extends Function.Call {
        public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
            evalContext.at(this);
            Item item = this.args[0].evalAsOptItem(focus, evalContext);
            if (item == null) {
                throw EmptyException.allowed();
            }
            DateTimeBase dateTimeBase = null;
            if (item instanceof MomentValue) {
                dateTimeBase = ((MomentValue)item).getValue();
            } else {
                try {
                    dateTimeBase = Date.parseDate(item.asString(), evalContext.getImplicitTimezone());
                }
                catch (DateTimeException dateTimeException) {
                    return evalContext.error((Expression)this, "cannot cast to xs:date : " + dateTimeException.getMessage());
                }
            }
            return new SingleDuration(new Duration(0, dateTimeBase.getTimeZone() * 60));
        }
    }
}

