/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.impl;

import java.text.Collator;
import java.util.HashMap;
import java.util.Vector;
import net.xfra.qizxopen.util.Collations;
import net.xfra.qizxopen.util.NSPrefixMapping;
import net.xfra.qizxopen.util.Namespace;
import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalException;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.Log;
import net.xfra.qizxopen.xquery.ModuleManager;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.fn.Function;
import net.xfra.qizxopen.xquery.fn.Prototype;
import net.xfra.qizxopen.xquery.fn.UserFunction;
import net.xfra.qizxopen.xquery.impl.DefaultEvalContext;
import net.xfra.qizxopen.xquery.impl.PredefinedModule;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.GlobalVariable;
import net.xfra.qizxopen.xquery.op.LocalVariable;
import net.xfra.qizxopen.xquery.op.Pragma;

public class Module
implements StaticContext {
    protected Log log;
    protected NSPrefixMapping nsTable = new NSPrefixMapping();
    protected Namespace defaultFunctionNS = Namespace.FN;
    protected Namespace defaultElementNS = Namespace.NONE;
    protected String baseURI = "";
    protected boolean checked = false;
    protected Module predefined = PredefinedModule.BASE;
    protected String physicalURI;
    protected Namespace moduleNS;
    protected CharSequence source;
    protected Vector importedModules = new Vector();
    protected HashMap functionMap = new HashMap();
    protected HashMap globalMap = new HashMap();
    protected HashMap registeredCollations;
    protected String defaultCollation = "http://www.w3.org/2003/05/xpath-functions/collation/codepoint";
    protected Collator defaultCollator = null;
    protected Vector declarations = new Vector();
    Pragma[] pragmas;
    protected LocalVariable locals;
    protected LocalVariable lastLocal;
    protected int maxLocalSize = 0;
    protected int localCnt;
    protected int localIntCnt;
    protected int localDoubleCnt;
    protected int localStringCnt;
    protected int localItemCnt;
    Expression[] exprStack = new Expression[40];
    int exprDepth = 0;
    public static Namespace LOCAL_NS = Namespace.get("http://www.w3.org/2003/11/xquery-local-functions");
    DotType dotTypeStack;

    public Module() {
        this.nsTable.addMapping("xml", Namespace.XML);
        this.nsTable.addMapping("xs", Namespace.XSD);
        this.nsTable.addMapping("xsi", Namespace.XSI);
        this.nsTable.addMapping("fn", Namespace.FN);
        this.nsTable.addMapping("xdt", Namespace.XDT);
        this.nsTable.addMapping("local", LOCAL_NS);
    }

    public void dump(ExprDump exprDump) {
        exprDump.println("Module");
        exprDump.display("declarations", this.declarations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void staticCheck(ModuleManager moduleManager, Log log) {
        if (this.checked) {
            return;
        }
        ModuleManager moduleManager2 = moduleManager;
        synchronized (moduleManager2) {
            this.checked = true;
            int n = 0;
            while (n < this.declarations.size()) {
                Object object;
                Object e = this.declarations.get(n);
                if (e instanceof GlobalVariable) {
                    object = (GlobalVariable)e;
                    Expression expression = ((GlobalVariable)object).init;
                    if (expression != null) {
                        ((GlobalVariable)object).init = expression = expression.staticCheck(this);
                        if (((Expression)object).getType() == null) {
                            ((Expression)object).setType(expression.getType());
                        } else if (!((Expression)object).getType().accepts(expression.getType())) {
                            log.error(this, expression.location, "incompatible value type %2 for variable %1", this.prefixedName(((GlobalVariable)object).name), expression.getType().toString(this));
                        }
                    } else if (((Expression)object).getType() == null) {
                        ((Expression)object).setType(Type.ANY);
                    }
                    GlobalVariable globalVariable = (GlobalVariable)this.globalMap.get(((GlobalVariable)object).name);
                    if (globalVariable != null) {
                        log.error(this, ((GlobalVariable)object).location, "global variable %1 already defined", this.prefixedName(((GlobalVariable)object).name));
                    } else {
                        this.globalMap.put(((GlobalVariable)object).name, object);
                    }
                } else if (e instanceof UserFunction) {
                    object = (UserFunction)e;
                    this.resetLocals();
                    ((UserFunction)object).staticCheck(this);
                    this.allocateLocalAddress(this.locals);
                    ((UserFunction)object).setLocalSize(this.maxLocalSize);
                } else if (e instanceof Module) {
                    object = (Module)e;
                    ((Module)object).staticCheck(moduleManager, log);
                    this.importedModules.add(object);
                }
                ++n;
            }
        }
    }

    public void initGlobals(DefaultEvalContext defaultEvalContext, HashMap hashMap) throws XQueryException {
        if (this.predefined != null) {
            this.predefined.initGlobals(defaultEvalContext, hashMap);
        }
        int n = 0;
        int n2 = this.declarations.size();
        while (n < n2) {
            Object object;
            if (this.declarations.get(n) instanceof GlobalVariable) {
                Value value;
                object = (GlobalVariable)this.declarations.get(n);
                if (((GlobalVariable)object).init != null) {
                    value = ((GlobalVariable)object).init.eval(null, defaultEvalContext);
                    defaultEvalContext.setGlobal((GlobalVariable)object, value);
                }
                if ((value = (Value)hashMap.get(((GlobalVariable)object).name)) != null) {
                    if (!((Expression)object).getType().test(value)) {
                        try {
                            value = value.bornAgain();
                            if (!value.next()) {
                                throw new EvalException("cannot cast empty initial value of " + ((GlobalVariable)object).name);
                            }
                            value = ((Expression)object).getType().getItemType().cast(value, defaultEvalContext);
                        }
                        catch (TypeException typeException) {
                            defaultEvalContext.error((Expression)object, typeException);
                        }
                    }
                    defaultEvalContext.setGlobal((GlobalVariable)object, value);
                }
            } else if (this.declarations.get(n) instanceof Module && hashMap.get(object = (Module)this.declarations.get(n)) == null) {
                hashMap.put(object, object);
                ((Module)object).initGlobals(defaultEvalContext, hashMap);
                hashMap.remove(object);
            }
            ++n;
        }
    }

    public int getLocalSize() {
        return this.maxLocalSize;
    }

    public Log getLog() {
        return this.log;
    }

    void setLog(Log log) {
        this.log = log;
    }

    void setSource(CharSequence charSequence, String string) {
        this.source = charSequence;
        this.physicalURI = string;
    }

    public CharSequence getSource() {
        return this.source;
    }

    public String printLocation(int n) {
        return this.physicalURI + (this.source == null ? ", character offset " + n : ", line " + Log.getLineNumber(this.source, n));
    }

    public void error(Expression expression, String string, String string2, String string3) {
        this.log.error(expression.module, expression.location, string, string2, string3);
    }

    public Expression staticCheck(Expression expression, int n) {
        Object object;
        if (this.exprDepth >= this.exprStack.length) {
            object = this.exprStack;
            this.exprStack = new Expression[((Expression[])object).length * 2];
            System.arraycopy(object, 0, this.exprStack, 0, ((Expression[])object).length);
        }
        this.exprStack[this.exprDepth++] = expression;
        object = expression.staticCheck(this);
        --this.exprDepth;
        return object;
    }

    public Expression getEnclosing(int n) {
        if (n < 0 || n > this.exprDepth - 1) {
            return null;
        }
        return this.exprStack[this.exprDepth - 1 - n];
    }

    public boolean check(Prototype prototype, int n, Expression expression) {
        if (!prototype.checkArg(n, expression)) {
            this.log.error(expression.module, expression.location, "argument '%2' of type %3 not acceptable in %1", new String[]{prototype.toString(this), prototype.getArgName(n, this), expression.getType().toString(this)});
            return false;
        }
        return true;
    }

    public Expression resolve(Prototype[] prototypeArray, Expression[] expressionArray, Expression expression) {
        Object object;
        boolean bl = false;
        int n = 0;
        while (n < prototypeArray.length) {
            if (prototypeArray[n].check(expressionArray)) break;
            ++n;
        }
        if (n >= prototypeArray.length) {
            bl = true;
            object = prototypeArray[0].displayName(this) + " cannot be applied to (";
            int n2 = 0;
            while (n2 < expressionArray.length) {
                if (n2 > 0) {
                    object = (String)object + ',';
                }
                object = (String)object + ' ';
                object = (String)object + expressionArray[n2].getType().toString(this);
                ++n2;
            }
            object = (String)object + " )";
            this.log.error(expression.module, expression.location, (String)object, "");
            this.log.info("known signature(s):");
            int n3 = 0;
            while (n3 < prototypeArray.length) {
                if (!prototypeArray[n3].hidden) {
                    this.log.info("  " + prototypeArray[n3].toString(this));
                }
                ++n3;
            }
            n = 0;
        }
        object = prototypeArray[n].newInstance(this, expressionArray);
        ((Expression)object).setType(prototypeArray[n].returnType);
        ((Function.Call)object).module = expression.module;
        ((Function.Call)object).location = expression.location;
        if (!bl) {
            ((Function.Call)object).compilationHook();
        }
        return object;
    }

    public void checkType(Expression expression, Type type, String string) {
        if (!type.accepts(expression.getType())) {
            this.log.error(expression.module, expression.location, "type error for %1: expecting %2", string, type.toString(this));
        }
    }

    public void setPredefinedModule(Module module) {
        this.predefined = module;
    }

    public Namespace getDefaultFunctionNS() {
        return this.defaultFunctionNS;
    }

    public Namespace getDefaultElementNS() {
        return this.defaultElementNS;
    }

    public void addDefaultNamespace(boolean bl, String string) {
        if (bl) {
            this.defaultFunctionNS = Namespace.get(string);
        } else {
            this.defaultElementNS = Namespace.get(string);
        }
    }

    public boolean addNamespaceDecl(String string, String string2) {
        if (this.nsTable.convertToNamespace(string) != null) {
            return false;
        }
        this.nsTable.addMapping(string, string2);
        return true;
    }

    public NSPrefixMapping getInScopeNS() {
        return this.nsTable;
    }

    public String prefixedName(QName qName) {
        String string = this.nsTable.convertToPrefix(qName.getNamespace());
        return string == null ? qName.toString() : string + ":" + qName.getLocalName();
    }

    public String getPhysicalURI() {
        return this.physicalURI;
    }

    public void setDeclaredURI(String string) {
        this.defaultFunctionNS = this.moduleNS = Namespace.get(string);
    }

    public String getDeclaredURI() {
        return this.moduleNS.getURI();
    }

    public Namespace getNamespace() {
        return this.moduleNS;
    }

    public Collator setDefaultCollation(String string) {
        this.defaultCollation = string;
        this.defaultCollator = this.getCollator(this.defaultCollation);
        return this.defaultCollator;
    }

    public String getDefaultCollation() {
        return this.defaultCollation;
    }

    public void setCollations(HashMap hashMap) {
        this.registeredCollations = hashMap;
    }

    public synchronized Collator getCollator(String string) {
        Collator collator;
        if (string == null) {
            return this.defaultCollator;
        }
        Collator collator2 = collator = this.registeredCollations == null ? null : (Collator)this.registeredCollations.get(string);
        if (collator == null) {
            collator = Collations.getInstanceWithStrength(string);
        }
        return collator;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void addDeclaration(Object object) {
        this.declarations.add(object);
    }

    public void storePragmas(Pragma[] pragmaArray) {
        this.pragmas = pragmaArray;
    }

    public Pragma[] getPragmas() {
        return this.pragmas;
    }

    Module importedModule(int n) {
        return (Module)this.importedModules.get(n);
    }

    ItemType lookForType(QName qName) {
        return Type.findItemType(qName);
    }

    public Function localFunctionLookup(QName qName) throws XQueryException {
        Function function = (Function)this.functionMap.get(qName);
        return function;
    }

    public Function functionLookup(QName qName) throws XQueryException {
        Function function = this.localFunctionLookup(qName);
        if (function != null) {
            return function;
        }
        int n = this.importedModules.size();
        while (--n >= 0) {
            function = this.importedModule(n).localFunctionLookup(qName);
            if (function == null) continue;
            return function;
        }
        return this.predefined.localFunctionLookup(qName);
    }

    public void declareFunction(Function function) {
        this.functionMap.put(function.getName(), function);
    }

    public GlobalVariable lookforGlobalVariable(QName qName) {
        GlobalVariable globalVariable = (GlobalVariable)this.globalMap.get(qName);
        if (globalVariable != null) {
            return globalVariable;
        }
        int n = this.importedModules.size();
        while (--n >= 0) {
            globalVariable = this.importedModule(n).lookforGlobalVariable(qName);
            if (globalVariable == null) continue;
            return globalVariable;
        }
        return this.predefined == null ? null : this.predefined.lookforGlobalVariable(qName);
    }

    public GlobalVariable defineGlobal(QName qName, Type type) {
        GlobalVariable globalVariable = new GlobalVariable(qName, type, null);
        this.globalMap.put(qName, globalVariable);
        this.addDeclaration(globalVariable);
        return globalVariable;
    }

    public LocalVariable lookforLocalVariable(QName qName) {
        LocalVariable localVariable = this.lastLocal;
        while (localVariable != null) {
            if (localVariable.name == qName) {
                return localVariable;
            }
            localVariable = localVariable.before;
        }
        return null;
    }

    public LocalVariable defineLocalVariable(QName qName, Type type, Expression expression) {
        LocalVariable localVariable = new LocalVariable(qName, type, expression);
        this.lastLocal.addAfter(localVariable);
        this.lastLocal = localVariable;
        return localVariable;
    }

    public LocalVariable markLocalVariables() {
        return this.lastLocal;
    }

    public void popLocalVariables(LocalVariable localVariable) {
        this.lastLocal = localVariable;
    }

    public void resetLocals() {
        this.maxLocalSize = 0;
        this.localItemCnt = 0;
        this.localStringCnt = 0;
        this.localDoubleCnt = 0;
        this.localIntCnt = 0;
        this.localCnt = 0;
        this.locals = this.lastLocal = new LocalVariable(null, null, null);
    }

    protected void allocateLocalAddress(LocalVariable localVariable) {
        int n = -1;
        Type type = localVariable.getType();
        if (localVariable.name != null) {
            if (localVariable.address < 0 || type.getOccurrence() != 0) {
                n = 20;
                localVariable.address = 20 + this.localCnt++;
                this.maxLocalSize = Math.max(localVariable.address, this.maxLocalSize);
            } else if (type == Type.INTEGER) {
                n = 0;
                localVariable.address = 0 + this.localIntCnt++;
                if (this.localIntCnt > 4) {
                    throw new RuntimeException("(internal) too many int registers");
                }
            } else if (type == Type.STRING) {
                n = 8;
                localVariable.address = 8 + this.localStringCnt++;
            } else if (type == Type.DOUBLE) {
                n = 4;
                localVariable.address = 4 + this.localDoubleCnt++;
            } else {
                n = 12;
                localVariable.address = 12 + this.localItemCnt++;
                if (this.localItemCnt > 8) {
                    throw new RuntimeException("(internal) too many Item registers");
                }
            }
        }
        LocalVariable localVariable2 = localVariable.after;
        while (localVariable2 != null) {
            this.allocateLocalAddress(localVariable2);
            localVariable2 = localVariable2.replacer;
        }
        switch (n) {
            case 20: {
                --this.localCnt;
                break;
            }
            case 0: {
                --this.localIntCnt;
                break;
            }
            case 8: {
                --this.localStringCnt;
                break;
            }
            case 4: {
                --this.localDoubleCnt;
                break;
            }
            case 12: {
                --this.localItemCnt;
            }
        }
    }

    public void pushDotType(Type type) {
        this.dotTypeStack = new DotType(type.getItemType(), this.dotTypeStack);
    }

    public void popDotType() {
        this.dotTypeStack = this.dotTypeStack.up;
    }

    public ItemType getDotType() {
        return this.dotTypeStack == null ? null : this.dotTypeStack.type;
    }

    private static class DotType {
        DotType up;
        ItemType type;

        DotType(ItemType itemType, DotType dotType) {
            this.type = itemType;
            this.up = dotType;
        }
    }
}

