/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.ItemType;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dm.Node;
import net.xfra.qizxopen.xquery.dm.NodeSequenceBase;
import net.xfra.qizxopen.xquery.op.BasicStep;
import net.xfra.qizxopen.xquery.op.ChildStep;
import net.xfra.qizxopen.xquery.op.DescendantOrSelfStep;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.NodeSortExpr;
import net.xfra.qizxopen.xquery.op.UnionOp;

public class PathExpr
extends Expression {
    public Expression[] steps = new Expression[0];
    boolean needsSort = false;

    public void addStep(Expression expression) {
        if (expression instanceof UnionOp) {
            expression = ((UnionOp)expression).reduce();
        }
        if (expression instanceof ChildStep && this.steps.length > 0 && this.steps[this.steps.length - 1] instanceof DescendantOrSelfStep) {
            BasicStep basicStep = (BasicStep)this.steps[this.steps.length - 1];
            if (basicStep.nodeTest == null) {
                basicStep.nodeTest = ((BasicStep)expression).nodeTest;
                return;
            }
        }
        this.steps = Expression.addExpr(this.steps, expression);
    }

    public Expression getStep(int n) {
        return n < 0 || n >= this.steps.length ? null : this.steps[n];
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this) && visitor.visit(this.steps);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "PathExpr");
        if (this.needsSort) {
            exprDump.display("needsSort", "" + this.needsSort);
        }
        exprDump.display("steps", this.steps);
    }

    public int getFlags() {
        return 8;
    }

    public Expression staticCheck(StaticContext staticContext) {
        this.type = staticContext.getDotType() == null ? Type.NODE.star : staticContext.getDotType();
        boolean bl = true;
        int n = 0;
        int n2 = this.steps.length;
        while (n < n2) {
            staticContext.pushDotType(this.type);
            Expression expression = this.steps[n] = staticContext.staticCheck(this.steps[n], 0);
            staticContext.popDotType();
            int n3 = this.steps[n].getFlags();
            if ((n3 & 8) == 0 || n > 0 && ((n3 & 1) == 0 || !bl) && (n3 & 2) == 0) {
                this.needsSort = true;
            }
            bl = (n3 & 4) != 0;
            this.type = this.steps[n].getType();
            if (!Type.NODE.star.accepts(this.type)) {
                staticContext.error(expression, "path step should have node type, not '%1', ", expression.getType().toString(staticContext), null);
            }
            ++n;
        }
        return this.needsSort ? new NodeSortExpr(this).atSamePlaceAs(this) : this;
    }

    public Value eval(Focus focus, EvalContext evalContext) throws XQueryException {
        Value value = this.getStep(0).eval(focus, evalContext);
        return this.evalNextSteps(value, 1, evalContext);
    }

    public Value evalNextSteps(Value value, int n, EvalContext evalContext) throws XQueryException {
        int n2 = n;
        int n3 = this.steps.length;
        while (n2 < n3) {
            value = new Composition(value, this.getStep(n2), evalContext);
            ++n2;
        }
        return value;
    }

    public class Composition
    extends NodeSequenceBase
    implements Focus {
        Value source;
        Expression step;
        EvalContext context;
        Value stepSeq;
        int position = 0;
        int last = -1;
        Node current;

        public Composition(Value value, Expression expression, EvalContext evalContext) {
            this.source = value;
            this.step = expression;
            this.context = evalContext;
            this.stepSeq = Value.empty;
            this.position = 0;
        }

        public Value bornAgain() {
            return new Composition(this.source.bornAgain(), this.step, this.context);
        }

        public boolean next() throws XQueryException {
            while (!this.stepSeq.next()) {
                if (!this.source.next()) {
                    return false;
                }
                ++this.position;
                this.current = this.source.asNode();
                this.context.at(this.step);
                this.stepSeq = this.step.eval(this, this.context);
            }
            return true;
        }

        public Node asNode() throws TypeException {
            return this.stepSeq.asNode();
        }

        public ItemType getType() {
            return this.stepSeq.getType();
        }

        public Item asItem() throws TypeException {
            return this.stepSeq.asItem();
        }

        public Item getItem() {
            return this.current;
        }

        public long getItemAsInteger() throws XQueryException {
            return this.source.asInteger();
        }

        public int getPosition() {
            return this.position;
        }

        public int getLast() {
            block3: {
                if (this.last >= 0) break block3;
                try {
                    Value value = this.source.bornAgain();
                    this.last = 0;
                    while (value.next()) {
                        ++this.last;
                    }
                }
                catch (Exception exception) {}
            }
            return this.last;
        }
    }
}

