/*
 * Decompiled with CFR 0.152.
 */
package net.xfra.qizxopen.xquery.op;

import net.xfra.qizxopen.util.QName;
import net.xfra.qizxopen.xquery.EvalContext;
import net.xfra.qizxopen.xquery.ExprDump;
import net.xfra.qizxopen.xquery.Focus;
import net.xfra.qizxopen.xquery.Item;
import net.xfra.qizxopen.xquery.StaticContext;
import net.xfra.qizxopen.xquery.Type;
import net.xfra.qizxopen.xquery.TypeException;
import net.xfra.qizxopen.xquery.Value;
import net.xfra.qizxopen.xquery.XQueryException;
import net.xfra.qizxopen.xquery.dt.GenericValue;
import net.xfra.qizxopen.xquery.op.Expression;
import net.xfra.qizxopen.xquery.op.LocalVariable;

public class VarClause
extends Expression {
    public QName variable;
    public Type varType;
    public LocalVariable varDecl;
    public Expression expr;
    public Expression owner;
    protected boolean checked = false;

    public VarClause(QName qName) {
        this.variable = qName;
    }

    public boolean visit(Expression.Visitor visitor) {
        return visitor.examine(this) && this.expr.visit(visitor);
    }

    public void dump(ExprDump exprDump) {
        exprDump.header(this, "VarClause");
        exprDump.display("variable", this.variable);
        exprDump.display("varAddress", this.varDecl.address);
        exprDump.display("varType", this.varType);
        exprDump.display("expr", this.expr);
    }

    public Expression staticCheck(StaticContext staticContext) {
        if (this.checked) {
            return this;
        }
        this.checked = true;
        this.varDecl = staticContext.defineLocalVariable(this.variable, this.varType, this);
        this.expr = staticContext.staticCheck(this.expr, 0);
        this.type = this.varType;
        if (this.varType == null) {
            this.varDecl.type = this.varType = this.expr.getType();
        } else if (!this.varType.accepts(this.expr.getType())) {
            staticContext.error(this, "incompatible value type %2 for variable %1", staticContext.prefixedName(this.variable), this.expr.getType().toString(staticContext));
        }
        this.varDecl.defineType(this.varType);
        return this;
    }

    public static class Sequence
    extends GenericValue {
        Value source;
        EvalContext context;
        Focus focus;
        boolean done = false;

        Sequence(Focus focus, EvalContext evalContext) {
            this.focus = focus;
            this.context = evalContext;
        }

        void setSource(Value value) {
            this.source = value;
        }

        public Item asItem() throws TypeException {
            return this.item;
        }

        public boolean next() throws XQueryException {
            if (this.done) {
                return false;
            }
            this.done = true;
            return true;
        }

        public Value bornAgain() {
            return new Sequence(this.focus, this.context);
        }
    }
}

