/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.dm;

import net.xfra.qizxopen.util.QName;

/**
 * 	Tests a node on behalf of path-steps or type matching.
 */
public interface NodeTest {

    /**
     *	@return true if node matched. A null name is always accepted.
     */
    boolean accepts( int kind, QName name );

    /**
     *	@return true if node matched. Used for extended tests like DocumentTest.
     */
    boolean accepts( Node node );

    /**
     *	@return true if the node itself is necessary for checking (not only the kind
     *	and name). Allows optimization (avoids building a Node just for testing).
     *	Returns true for extended tests like DocumentTest.
     */
    boolean needsNode();

    /**
     *	Returns the node kind (Node.ELEMENT, Node.TEXT etc) or -1 if not simple.
     */
    int getNodeKind();

    /**
     *	Returns true for simple node test (node kind only).
     */
    boolean staticallyCheckable();
}
