/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 *  Abstract converter from string to date-time (expressed in seconds from UTC epoch).
 */
public interface DateConverter extends NumberConverter
{
    /**
     *  Converts the date to a double (in seconds from UTC epoch).
     *  If the conversion is not possible, returns NaN.
     *  The string passed has no leading whitespace.
     */
    double convert(String date);
}
