/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

import java.util.Date;
import java.text.DateFormat;
import java.text.ParsePosition;

/**
 *	DateConverter for the default locale.
 */
public class DefaultDateConverter implements DateConverter
{
    DateFormat format;
    ParsePosition position = new ParsePosition(0);

    /**
     * Uses the default locale.
     */
    public DefaultDateConverter() {
        this.format = DateFormat.getDateInstance(DateFormat.SHORT);
    }

    /**
     *	General case: use a DateFormat.
     */
    public DefaultDateConverter(DateFormat format) {
	this.format = format;
    }

    /**
     *	Returns a number of seconds since 1970-01-01 00:00:00 UTC.
     */
    public double convert( String value ) {
	position.setIndex(0);
	Date d = format.parse(value, position);
	if(d == null || position.getIndex() == 0)
	    return Double.NaN;
	return d.getTime() / 1000.0;
    }

} // end of class DefaultDateConverter
