/*
 *	Qizx/Open version 0.3
 *
 *	Copyright (c) 2003-2004 Xavier C. FRANC -- All rights reserved.
 *
 *	This program is free software; you can redistribute it  and/or
 *	modify it under the terms of the GNU General Public License as
 *	published by the Free Software Foundation (see LICENSE.txt).
 */

package net.xfra.qizxopen.util;

/**
 * Unix-style globing	
 */
public class StringGlob extends StringMatcher
{
    public StringGlob(char[] string, int length) {
	super(string, length);
	exact = false;
    }

    public boolean matches(char[] string) {
	return glob(string, 0, pattern, 0);
    }

    public String toString() {
	return "Glob "+new String(pattern);
    }

    public static boolean glob(char[] string, int ps, char[] pattern, int pp) {
	int slen = string.length;
	int plen = pattern.length;

	for( ; ; ++pp, ++ps) {
	    // See if we're at the end of both the pattern and the string.
	    // If so, we succeeded.  If we're at the end of the pattern
	    // but not at the end of the string, we failed.
	    if (pp == plen)
		return (ps == slen);
		
	    if (ps == slen && pattern[pp] != '*')
		return false;
		
	    // Check for a "*" as the next pattern character.  It matches
	    // any substring.  We handle this by calling ourselves
	    // recursively for each postfix of string, until either we
	    // match or we reach the end of the string.
	    if (pattern[pp] == '*') {
		++ pp;
		if (pp == plen)
		    return true;	// no need to go on

		for( ; ; ps ++) {
		    if (glob(string, ps, pattern, pp))
			return true;
		    if (ps == slen)
			return false;
		}
	    }
		
	    // Check for a "?" as the next pattern character.  It matches
	    // any single character.
	    if (pattern[pp] == '?')
		continue;
		
	    /* If the next pattern character is '\', just it strip off
	     * so we do exact matching on the character that follows.
	     */
		
	    if (pattern[pp] == '\\')
		if (++pp == plen)
		    return false;
		
	    // There's no special character.  Just make sure that the next
	    // characters of each string match.
	    if (pattern[pp] != string[ps])
		return false;
	}
    }

    static public void main( String args[] )
    {
        try {
	    char[] s = args[0].toCharArray();
	    char[] p = args[1].toCharArray();
            boolean res = glob(s, 0, p, 0);
	    System.out.println(" "+res);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
